/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.mtr.core.tool.Utilities;
import org.mtr.mod.data.IGui;

public enum DisplayOption {
    NONE(null),
    SINGLE_LINE(Utilities::formatName),
    UPPER_CASE(String::toUpperCase),
    SPACE_CJK(text -> {
        CharSequence[] textSplit = text.split("\\|");
        for (int i = 0; i < textSplit.length; ++i) {
            if (textSplit[i].length() != 2 || !IGui.isCjk((String)textSplit[i])) continue;
            textSplit[i] = String.format("%s %s", Character.valueOf(((String)textSplit[i]).charAt(0)), Character.valueOf(((String)textSplit[i]).charAt(1)));
        }
        return String.join((CharSequence)"|", textSplit);
    }),
    SCROLL_NORMAL(null),
    SCROLL_LIGHT_RAIL(null),
    SEVEN_SEGMENT(text -> text.replaceAll("\\D", "")),
    ALIGN_LEFT_CJK(null),
    ALIGN_RIGHT_CJK(null),
    ALIGN_LEFT(null),
    ALIGN_RIGHT(null),
    ALIGN_TOP(null),
    ALIGN_BOTTOM(null),
    CYCLE_LANGUAGES(text -> {
        String[] textSplit = text.split("\\|");
        return textSplit.length == 0 ? "" : textSplit[(int)(System.currentTimeMillis() / 1000L % (long)textSplit.length)];
    });

    @Nullable
    private final Function<String, String> format;

    private DisplayOption(Function<String, String> format) {
        this.format = format;
    }

    public String format(String text) {
        return this.format == null ? text : this.format.apply(text);
    }
}

