/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockTrainSensorBase;

public class PacketUpdateTrainSensorConfig
extends PacketHandler {
    protected final BlockPos blockPos;
    protected final LongAVLTreeSet filterRouteIds;
    protected final boolean stoppedOnly;
    protected final boolean movingOnly;

    public PacketUpdateTrainSensorConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong(packetBufferReceiver.readLong());
        int routeIdCount = packetBufferReceiver.readInt();
        this.filterRouteIds = new LongAVLTreeSet();
        for (int i = 0; i < routeIdCount; ++i) {
            this.filterRouteIds.add(packetBufferReceiver.readLong());
        }
        this.stoppedOnly = packetBufferReceiver.readBoolean();
        this.movingOnly = packetBufferReceiver.readBoolean();
    }

    public PacketUpdateTrainSensorConfig(BlockPos blockPos, LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
        this.blockPos = blockPos;
        this.filterRouteIds = filterRouteIds;
        this.stoppedOnly = stoppedOnly;
        this.movingOnly = movingOnly;
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.filterRouteIds.size());
        this.filterRouteIds.forEach(packetBufferSender::writeLong);
        packetBufferSender.writeBoolean(this.stoppedOnly);
        packetBufferSender.writeBoolean(this.movingOnly);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        if (!Init.isChunkLoaded(serverPlayerEntity.getEntityWorld(), this.blockPos)) {
            return;
        }
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockTrainSensorBase.BlockEntityBase) {
            ((BlockTrainSensorBase.BlockEntityBase)((Object)entity.data)).setData(this.filterRouteIds, this.stoppedOnly, this.movingOnly);
        }
    }
}

