/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFieldWidgetAbstractMapping;
import org.mtr.mapping.holder.TextRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;

public class TextFieldWidgetExtension
extends TextFieldWidgetAbstractMapping {
    private final int maxLength;
    private final TextCase textCase;
    private final String filter;
    private final String suggestion;

    @MappedMethod
    public TextFieldWidgetExtension(int x, int y, int width, int height, int maxLength, TextCase textCase, @RegEx @Nullable String filter, @Nullable String suggestion) {
        this(x, y, width, height, "", maxLength, textCase, filter, suggestion);
    }

    @MappedMethod
    public TextFieldWidgetExtension(int x, int y, int width, int height, String message, int maxLength, TextCase textCase, @RegEx @Nullable String filter, @Nullable String suggestion) {
        this(x, y, width, height, TextHelper.literal(message), maxLength, textCase, filter, suggestion);
    }

    @MappedMethod
    public TextFieldWidgetExtension(int x, int y, int width, int height, MutableText text, int maxLength, TextCase textCase, @RegEx @Nullable String filter, @Nullable String suggestion) {
        super(new TextRenderer(class_310.method_1551().field_1772), x, y, width, height, new Text((class_2561)text.data));
        this.maxLength = maxLength;
        this.textCase = textCase;
        this.filter = filter;
        this.suggestion = suggestion;
        this.setChangedListener2(value -> {});
        this.setMaxLength2(0);
    }

    @MappedMethod
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        if (graphicsHolder.drawContext != null) {
            super.method_48579(graphicsHolder.drawContext, mouseX, mouseY, delta);
        }
    }

    @Deprecated
    public final void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        GraphicsHolder.createInstanceSafe(drawContext, graphicsHolder -> this.render((GraphicsHolder)graphicsHolder, mouseX, mouseY, delta));
    }

    @Deprecated
    public final boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.mouseScrolled2(mouseX, mouseY, amount);
    }

    @MappedMethod
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    @MappedMethod
    public final void setChangedListener2(Consumer<String> changedListener) {
        super.setChangedListener2(text -> {
            String newText;
            if (this.filter == null || this.filter.isEmpty()) {
                newText = this.trySetLength(this.textCase.convert.apply((String)text));
            } else {
                newText = this.trySetLength(this.textCase.convert.apply((String)text).replaceAll(this.filter, ""));
                if (!newText.equals(text)) {
                    this.setText2(newText);
                }
            }
            this.setSuggestion2(newText.isEmpty() && this.suggestion != null ? this.suggestion : "");
            changedListener.accept(newText);
        });
    }

    @Override
    @MappedMethod
    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        if (this.isVisible2() && TextFieldWidgetExtension.isBetween(mouseX, this.getX2(), this.getX2() + this.field_22758) && TextFieldWidgetExtension.isBetween(mouseY, this.getY2(), this.getY2() + this.field_22759)) {
            if (button == 1) {
                this.setText2("");
            }
            return super.mouseClicked2(mouseX, mouseY, 0);
        }
        this.setTextFieldFocused2(false);
        return false;
    }

    @Deprecated
    public final void method_1865() {
        this.tick2();
    }

    @MappedMethod
    public void tick2() {
        super.method_1865();
    }

    @Override
    @Deprecated
    public final void setMaxLength2(int maxLength) {
        super.setMaxLength2(Integer.MAX_VALUE);
    }

    private String trySetLength(String text) {
        return text.isEmpty() ? "" : text.substring(0, Math.min(this.maxLength, text.length()));
    }

    private static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    @MappedMethod
    public final int getX2() {
        return super.method_46426();
    }

    @MappedMethod
    public final int getY2() {
        return super.method_46427();
    }

    @Override
    @MappedMethod
    public final void setX2(int x) {
        super.setX2(x);
    }

    @MappedMethod
    public final void setY2(int y) {
        super.method_46419(y);
    }

    @MappedMethod
    public final boolean method_49606() {
        return super.method_49606();
    }
}

