/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.tool.DummyClass;

public final class ModelPartExtension
extends DummyClass {
    class_630 modelPart;
    private float tempPivotX;
    private float tempPivotY;
    private float tempPivotZ;
    private float tempRotationX;
    private float tempRotationY;
    private float tempRotationZ;
    private int tempU;
    private int tempV;
    private class_5610 modelPartData;
    private boolean childAdded = false;
    private final List<String> nameTree = new ArrayList<String>();

    ModelPartExtension(class_5610 modelPartData) {
        this.nameTree.add(ModelPartExtension.getRandomPartName());
        this.modelPartData = modelPartData;
    }

    private ModelPartExtension(String name, class_5610 modelPartData) {
        this.nameTree.add(name);
        this.modelPartData = modelPartData;
    }

    @MappedMethod
    public void setPivot(float x, float y, float z) {
        this.tempPivotX = x;
        this.tempPivotY = y;
        this.tempPivotZ = z;
    }

    @MappedMethod
    public ModelPartExtension setTextureUVOffset(int textureOffsetU, int textureOffsetV) {
        this.tempU = textureOffsetU;
        this.tempV = textureOffsetV;
        return this;
    }

    @MappedMethod
    public void setRotation(float rotationX, float rotationY, float rotationZ) {
        this.tempRotationX = rotationX;
        this.tempRotationY = rotationY;
        this.tempRotationZ = rotationZ;
    }

    @MappedMethod
    public ModelPartExtension addChild() {
        this.setChild();
        String name = ModelPartExtension.getRandomPartName();
        ModelPartExtension modelPartExtension = new ModelPartExtension(name, this.modelPartData.method_32117(name, class_5606.method_32108(), this.getModelTransform()));
        modelPartExtension.nameTree.addAll(0, this.nameTree);
        return modelPartExtension;
    }

    @MappedMethod
    public void addCuboid(float x, float y, float z, int sizeX, int sizeY, int sizeZ, float inflation, boolean mirrored) {
        this.setChild();
        String name = ModelPartExtension.getRandomPartName();
        class_5606 modelPartBuilder = class_5606.method_32108().method_32106(mirrored).method_32105(name, x, y, z, sizeX, sizeY, sizeZ, new class_5605(inflation), this.tempU, this.tempV);
        this.modelPartData.method_32117(name, modelPartBuilder, this.getModelTransform());
    }

    @MappedMethod
    public void setOffset(float x, int y, float z) {
        if (this.modelPart != null) {
            this.modelPart.method_2851(x, (float)y, z);
        }
    }

    @MappedMethod
    public void render(GraphicsHolder graphicsHolder, float x, float z, float rotateY, int light, int overlay) {
        this.render(graphicsHolder, x, 0.0f, z, rotateY, light, overlay);
    }

    @MappedMethod
    public void render(GraphicsHolder graphicsHolder, float x, float y, float z, float rotateY, int light, int overlay) {
        if (this.modelPart != null) {
            this.modelPart.method_2851(x, y, z);
            this.modelPart.field_3675 = rotateY;
            if (graphicsHolder.matrixStack != null && graphicsHolder.vertexConsumer != null) {
                this.modelPart.method_22698(graphicsHolder.matrixStack, graphicsHolder.vertexConsumer, light, overlay);
            }
        }
    }

    @Deprecated
    void setModelPart(class_630 mainModelPart) {
        this.modelPart = mainModelPart;
        this.nameTree.forEach(name -> {
            this.modelPart = this.modelPart.method_32086(name);
        });
    }

    private void setChild() {
        if (!this.childAdded) {
            this.modelPartData = this.modelPartData.method_32117(this.getLastName(), class_5606.method_32108(), class_5603.method_32091((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            this.childAdded = true;
        }
    }

    private String getLastName() {
        return this.nameTree.isEmpty() ? "" : this.nameTree.get(this.nameTree.size() - 1);
    }

    private class_5603 getModelTransform() {
        return class_5603.method_32091((float)this.tempPivotX, (float)this.tempPivotY, (float)this.tempPivotZ, (float)this.tempRotationX, (float)this.tempRotationY, (float)this.tempRotationZ);
    }

    private static String getRandomPartName() {
        return "part" + Math.abs(new Random().nextLong());
    }
}

