/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.legacy.resource;

import java.util.Locale;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;
import org.mtr.core.serializer.JsonReader;
import org.mtr.legacy.resource.LegacyObjectResource;
import org.mtr.legacy.resource.LegacyRailResource;
import org.mtr.legacy.resource.LegacySignResource;
import org.mtr.legacy.resource.LegacyVehicleResource;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.config.Config;
import org.mtr.mod.resource.CustomResources;
import org.mtr.mod.resource.ObjectResource;
import org.mtr.mod.resource.RailResource;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.resource.VehicleResource;

public final class CustomResourcesConverter {
    public static CustomResources convert(JsonObject jsonObject, ResourceProvider resourceProvider) {
        boolean hasCustomTrains = jsonObject.getAsJsonObject().has("custom_trains");
        boolean hasCustomSigns = jsonObject.getAsJsonObject().has("custom_signs");
        if (!hasCustomTrains && !hasCustomSigns) {
            return new CustomResources(new JsonReader(jsonObject), resourceProvider);
        }
        ObjectArrayList<VehicleResource> vehicleResources = new ObjectArrayList<VehicleResource>();
        if (hasCustomTrains) {
            jsonObject.getAsJsonObject("custom_trains").entrySet().forEach(entry -> {
                try {
                    new LegacyVehicleResource(new JsonReader((JsonElement)entry.getValue())).convert(vehicleResources, ((String)entry.getKey()).toLowerCase(Locale.ENGLISH), resourceProvider);
                }
                catch (Exception e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
            });
        }
        ObjectArrayList<SignResource> signResources = new ObjectArrayList<SignResource>();
        if (hasCustomSigns) {
            jsonObject.getAsJsonObject("custom_signs").entrySet().forEach(entry -> {
                try {
                    new LegacySignResource(new JsonReader((JsonElement)entry.getValue())).convert(signResources, (String)entry.getKey());
                }
                catch (Exception e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
            });
        }
        return new CustomResources(vehicleResources, signResources);
    }

    public static void convertRails(Consumer<RailResource> callback, ResourceProvider resourceProvider) {
        ResourceManagerHelper.readDirectory("rails", (identifier, inputStream2) -> {
            if (identifier.getNamespace().equals("mtrsteamloco") && identifier.getPath().endsWith(".json")) {
                try {
                    JsonObject jsonObject = Config.readResource(inputStream2).getAsJsonObject();
                    if (jsonObject.has("model")) {
                        callback.accept(new LegacyRailResource(new JsonReader(jsonObject)).convert(FilenameUtils.getBaseName((String)identifier.getPath()), resourceProvider));
                    } else {
                        jsonObject.entrySet().forEach(entry -> callback.accept(new LegacyRailResource(new JsonReader((JsonElement)entry.getValue())).convert(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), resourceProvider)));
                    }
                }
                catch (Exception e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
            }
        });
    }

    public static void convertObjects(Consumer<ObjectResource> callback, ResourceProvider resourceProvider) {
        ResourceManagerHelper.readDirectory("eyecandies", (identifier, inputStream2) -> {
            if (identifier.getNamespace().equals("mtrsteamloco") && identifier.getPath().endsWith(".json")) {
                try {
                    JsonObject jsonObject = Config.readResource(inputStream2).getAsJsonObject();
                    if (jsonObject.has("model")) {
                        callback.accept(new LegacyObjectResource(new JsonReader(jsonObject)).convert(FilenameUtils.getBaseName((String)identifier.getPath()), resourceProvider));
                    } else {
                        jsonObject.entrySet().forEach(entry -> callback.accept(new LegacyObjectResource(new JsonReader((JsonElement)entry.getValue())).convert(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), resourceProvider)));
                    }
                }
                catch (Exception e) {
                    Init.LOGGER.error("", (Throwable)e);
                }
            }
        });
    }
}

