/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ReflectionUtils;

public class GravityChangerCompatibility {
    private static final boolean GRAVITY_API_LOADED = ModLoaderUtils.isModLoaded("gravity_api");
    private static final boolean GRAVITY_CHANGER_LOADED = ModLoaderUtils.isModLoaded("gravitychanger");
    public static final GravityChangerCompatibility INSTANCE = new GravityChangerCompatibility();
    private final Optional<Method> getterMethod;
    private final Optional<Method> oldGetterMethod;
    private final Optional<Method> accessorGetterMethod;
    private boolean enabled;

    private GravityChangerCompatibility() {
        boolean bl = this.enabled = GRAVITY_API_LOADED || GRAVITY_CHANGER_LOADED;
        if (this.enabled) {
            Optional<Class<?>> apiClass = ReflectionUtils.getClass("com.fusionflux.gravity_api.api.GravityChangerAPI");
            this.getterMethod = ReflectionUtils.getMethod(apiClass, "getGravityDirection", class_1297.class);
            Optional<Class<?>> oldApiClass = ReflectionUtils.getClass("me.andrew.gravitychanger.api.GravityChangerAPI");
            this.oldGetterMethod = ReflectionUtils.getMethod(oldApiClass, "getAppliedGravityDirection", class_1657.class);
            Optional<Class<?>> accessorClass = ReflectionUtils.getClass("me.andrew.gravitychanger.accessor.EntityAccessor");
            this.accessorGetterMethod = ReflectionUtils.getMethod(accessorClass, "gravitychanger$getAppliedGravityDirection", new Class[0]);
        } else {
            this.getterMethod = Optional.empty();
            this.oldGetterMethod = Optional.empty();
            this.accessorGetterMethod = Optional.empty();
        }
    }

    public class_2350 getGravityDirection(class_1657 entity) {
        if (this.enabled) {
            return this.getterMethod.map(m -> {
                try {
                    return (class_2350)m.invoke(null, entity);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return class_2350.field_11033;
                }
            }).orElseGet(() -> this.oldGetterMethod.map(m -> {
                try {
                    return (class_2350)m.invoke(null, entity);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return class_2350.field_11033;
                }
            }).orElseGet(() -> this.accessorGetterMethod.map(m -> {
                try {
                    return (class_2350)m.invoke((Object)entity, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return class_2350.field_11033;
                }
            }).orElse(class_2350.field_11033)));
        }
        return class_2350.field_11033;
    }

    public float getXCorrection(class_1657 player) {
        if (this.enabled) {
            class_2350 gravity = this.getGravityDirection(player);
            switch (gravity) {
                case field_11039: {
                    return 1.5f;
                }
                case field_11034: {
                    return -1.5f;
                }
            }
        }
        return 0.0f;
    }

    public float getYCorrection(class_1657 player) {
        if (this.enabled) {
            class_2350 gravity = this.getGravityDirection(player);
            switch (gravity) {
                case field_11036: {
                    return -3.0f;
                }
                case field_11033: {
                    break;
                }
                default: {
                    return -1.5f;
                }
            }
        }
        return 0.0f;
    }

    public float getZCorrection(class_1657 player) {
        if (this.enabled) {
            class_2350 gravity = this.getGravityDirection(player);
            switch (gravity) {
                case field_11043: {
                    return 1.5f;
                }
                case field_11035: {
                    return -1.5f;
                }
            }
        }
        return 0.0f;
    }
}

