/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.util.gson.PostProcessingEnabler;

public final class JsonUtils {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new PostProcessingEnabler()).registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).registerTypeAdapter(GameProfile.class, (Object)new GameProfile.Serializer()).setPrettyPrinting().create();

    private JsonUtils() {
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)GSON.fromJson(json, clazz);
    }

    public static <T> T fromJson(JsonElement json, Class<T> clazz) {
        return (T)GSON.fromJson(json, clazz);
    }

    public static <T> T fromJson(String json, Type type) {
        return (T)GSON.fromJson(json, type);
    }

    public static <T> String toJson(T obj) {
        return GSON.toJson(obj);
    }

    public static JsonObject parseJson(String json) {
        return (JsonObject)GSON.fromJson(json, JsonObject.class);
    }

    public static JsonObject skinPropertyToJson(Property property) {
        try {
            JsonObject json = (JsonObject)GSON.fromJson(new String(Base64.getDecoder().decode(property.getValue()), StandardCharsets.UTF_8), JsonObject.class);
            if (json != null) {
                json.remove("timestamp");
            }
            return json;
        }
        catch (Exception e) {
            SkinRestorer.LOGGER.error("Could not parse skin property", (Throwable)e);
            return null;
        }
    }
}

