/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.Pair;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.provider.collection.CollectionProviderConfig;
import net.lionarius.skinrestorer.config.provider.collection.CollectionSkinSource;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.MineskinSkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.util.Result;
import org.jetbrains.annotations.NotNull;

public final class CollectionSkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "collection";
    private static LoadingCache<Integer, Optional<Property>> SKIN_CACHE;
    private static List<Pair<URI, SkinVariant>> COLLECTION_SKINS;

    public static void reload() {
        COLLECTION_SKINS = CollectionSkinProvider.loadCollectionSkins();
        CollectionSkinProvider.createCache();
    }

    private static List<Pair<URI, SkinVariant>> loadCollectionSkins() {
        ArrayList<Pair<URI, SkinVariant>> skins = new ArrayList<Pair<URI, SkinVariant>>();
        CollectionProviderConfig config = SkinRestorer.getConfig().providersConfig().collection();
        for (CollectionSkinSource source : config.sources()) {
            URI uri = source.uri();
            if (uri == null) continue;
            skins.add((Pair<URI, SkinVariant>)Pair.of((Object)uri, (Object)((Object)source.variant())));
        }
        return skins;
    }

    private static void createCache() {
        CollectionProviderConfig config = SkinRestorer.getConfig().providersConfig().collection();
        long time = config.cache().enabled() ? config.cache().duration() : 0L;
        SKIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(time, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Integer, Optional<Property>>(){

            @NotNull
            public Optional<Property> load(@NotNull Integer key) throws Exception {
                Pair<URI, SkinVariant> skinEntry = COLLECTION_SKINS.get(key);
                return MineskinSkinProvider.loadSkin((URI)skinEntry.first(), (SkinVariant)((Object)skinEntry.second()));
            }
        });
    }

    @Override
    public String getArgumentName() {
        return "seed";
    }

    @Override
    public boolean hasVariantSupport() {
        return false;
    }

    @Override
    public Result<Optional<Property>, Exception> fetchSkin(String argument, SkinVariant variant) {
        if (COLLECTION_SKINS.isEmpty()) {
            return Result.error(new IllegalStateException("No collection skins configured"));
        }
        int skinIndex = Math.abs(argument.hashCode()) % COLLECTION_SKINS.size();
        try {
            return Result.success((Optional)SKIN_CACHE.get((Object)skinIndex));
        }
        catch (UncheckedExecutionException e) {
            return Result.error((Exception)e.getCause());
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }
}

