/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.fabric.compat.skinshuffle;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshPayload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshV1Payload;
import net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleSkinRefreshV2Payload;
import net.lionarius.skinrestorer.fabric.SkinRestorerFabric;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class SkinShuffleCompatibility {
    private SkinShuffleCompatibility() {
    }

    public static void initialize() {
        if (!SkinRestorerFabric.FABRIC_API_LOADED) {
            SkinRestorer.LOGGER.warn("fabric-api is not loaded, SkinShuffle compatibility will not be available");
            return;
        }
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleCompatibility.onPlayerJoin(handler.method_32311()));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SkinShuffleSkinRefreshV1Payload.PACKET_ID, SkinShuffleCompatibility::handleSkinRefreshV1Packet);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SkinShuffleSkinRefreshV2Payload.PACKET_ID, SkinShuffleCompatibility::handleSkinRefreshV2Packet);
    }

    private static void handleSkinRefreshV1Packet(MinecraftServer server, class_3222 player, class_3244 listener, class_2540 buf, PacketSender sender) {
        SkinShuffleSkinRefreshV1Payload payload = SkinShuffleSkinRefreshV1Payload.decode(buf);
        SkinShuffleCompatibility.handleSkinRefreshPacket(payload, server, player);
    }

    private static void handleSkinRefreshV2Packet(MinecraftServer server, class_3222 player, class_3244 listener, class_2540 buf, PacketSender sender) {
        SkinShuffleSkinRefreshV2Payload payload = SkinShuffleSkinRefreshV2Payload.decode(buf);
        SkinShuffleCompatibility.handleSkinRefreshPacket(payload, server, player);
    }

    private static void handleSkinRefreshPacket(SkinShuffleSkinRefreshPayload payload, MinecraftServer server, class_3222 player) {
        net.lionarius.skinrestorer.compat.skinshuffle.SkinShuffleCompatibility.handleSkinRefresh(server, player, payload);
    }
}

