/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.config.provider;

import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.provider.ElyByProviderConfig;
import net.lionarius.skinrestorer.config.provider.MineskinProviderConfig;
import net.lionarius.skinrestorer.config.provider.MojangProviderConfig;
import net.lionarius.skinrestorer.config.provider.collection.CollectionProviderConfig;
import net.lionarius.skinrestorer.util.gson.GsonPostProcessable;

public final class ProvidersConfig
implements GsonPostProcessable {
    public static final ProvidersConfig DEFAULT = new ProvidersConfig(new MojangProviderConfig(), new ElyByProviderConfig(), new MineskinProviderConfig(), new CollectionProviderConfig());
    private MojangProviderConfig mojang;
    private ElyByProviderConfig ely_by;
    private MineskinProviderConfig mineskin;
    private CollectionProviderConfig collection;

    public ProvidersConfig(MojangProviderConfig mojang, ElyByProviderConfig ely_by, MineskinProviderConfig mineskin, CollectionProviderConfig collection) {
        this.mojang = mojang;
        this.ely_by = ely_by;
        this.mineskin = mineskin;
        this.collection = collection;
    }

    public MojangProviderConfig mojang() {
        return this.mojang;
    }

    public ElyByProviderConfig ely_by() {
        return this.ely_by;
    }

    public MineskinProviderConfig mineskin() {
        return this.mineskin;
    }

    public CollectionProviderConfig collection() {
        return this.collection;
    }

    @Override
    public void gsonPostProcess() {
        if (this.mojang == null) {
            SkinRestorer.LOGGER.warn("Mojang provider config is null, using default");
            this.mojang = DEFAULT.mojang();
        }
        if (this.ely_by == null) {
            SkinRestorer.LOGGER.warn("Ely.By provider config is null, using default");
            this.ely_by = DEFAULT.ely_by();
        }
        if (this.mineskin == null) {
            SkinRestorer.LOGGER.warn("Mineskin provider config is null, using default");
            this.mineskin = DEFAULT.mineskin();
        }
        if (this.collection == null) {
            SkinRestorer.LOGGER.warn("Collection provider config is null, using default");
            this.collection = DEFAULT.collection();
        }
    }
}

