/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer;

import com.google.common.base.Throwables;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.lionarius.skinrestorer.command.SkinCommand;
import net.lionarius.skinrestorer.config.Config;
import net.lionarius.skinrestorer.config.provider.BuiltInProviderConfig;
import net.lionarius.skinrestorer.exception.TransparentException;
import net.lionarius.skinrestorer.platform.Services;
import net.lionarius.skinrestorer.skin.SkinIO;
import net.lionarius.skinrestorer.skin.SkinStorage;
import net.lionarius.skinrestorer.skin.SkinValue;
import net.lionarius.skinrestorer.skin.provider.CollectionSkinProvider;
import net.lionarius.skinrestorer.skin.provider.ElyBySkinProvider;
import net.lionarius.skinrestorer.skin.provider.MineskinSkinProvider;
import net.lionarius.skinrestorer.skin.provider.MojangSkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.skin.provider.SkinProviderRegistry;
import net.lionarius.skinrestorer.translation.Translation;
import net.lionarius.skinrestorer.util.FileUtils;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.TickedScheduler;
import net.lionarius.skinrestorer.util.WebUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SkinRestorer {
    public static final String MOD_ID = "skinrestorer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SkinRestorer");
    private static final SkinProviderRegistry providersRegistry = new SkinProviderRegistry();
    private static SkinStorage skinStorage;
    private static Path configDir;
    private static Config config;
    private static TickedScheduler tickedScheduler;
    private static MinecraftServer minecraftServer;

    private SkinRestorer() {
    }

    public static SkinStorage getSkinStorage() {
        return skinStorage;
    }

    public static Path getConfigDir() {
        return configDir;
    }

    public static Config getConfig() {
        return config;
    }

    public static SkinProviderRegistry getProvidersRegistry() {
        return providersRegistry;
    }

    public static TickedScheduler getTickedScheduler() {
        return tickedScheduler;
    }

    @Nullable
    public static MinecraftServer getMinecraftServer() {
        return minecraftServer;
    }

    public static Optional<SkinProvider> getProvider(String name) {
        return Optional.ofNullable(providersRegistry.get(name));
    }

    public static class_2960 resourceLocation(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static String assetPath(String name) {
        return String.format("/assets/%s/%s", MOD_ID, name);
    }

    public static void onInitialize() {
        configDir = Services.PLATFORM.getConfigDirectory().resolve(MOD_ID);
        SkinRestorer.reloadConfig();
        providersRegistry.register("empty", SkinProvider.EMPTY, false);
        providersRegistry.register("skinshuffle", SkinProvider.SKIN_SHUFFLE, false);
        SkinRestorer.registerDefaultSkinProvider("mojang", SkinProvider.MOJANG, SkinRestorer.getConfig().providersConfig().mojang());
        SkinRestorer.registerDefaultSkinProvider("ely.by", SkinProvider.ELY_BY, SkinRestorer.getConfig().providersConfig().ely_by());
        SkinRestorer.registerDefaultSkinProvider("web", SkinProvider.MINESKIN, SkinRestorer.getConfig().providersConfig().mineskin());
        SkinRestorer.registerDefaultSkinProvider("collection", SkinProvider.COLLECTION, SkinRestorer.getConfig().providersConfig().collection());
    }

    private static void registerDefaultSkinProvider(String defaultName, SkinProvider provider, BuiltInProviderConfig config) {
        boolean isDefaultName = config.name().equals(defaultName);
        providersRegistry.register(defaultName, provider, config.enabled() && isDefaultName);
        if (!isDefaultName && !SkinProvider.BUILTIN_PROVIDER_NAMES.contains(config.name())) {
            providersRegistry.register(config.name(), provider, config.enabled());
        }
    }

    public static void reloadConfig() {
        config = Config.load(SkinRestorer.getConfigDir());
        Translation.reloadTranslations();
        WebUtils.recreateHttpClient();
        MojangSkinProvider.reload();
        ElyBySkinProvider.reload();
        MineskinSkinProvider.reload();
        CollectionSkinProvider.reload();
    }

    public static Collection<class_3222> applySkin(MinecraftServer server, Iterable<GameProfile> targets, SkinValue value, boolean save) {
        HashSet<class_3222> acceptedPlayers = new HashSet<class_3222>();
        for (GameProfile profile : targets) {
            if (!SkinRestorer.getSkinStorage().hasSavedSkin(profile.getId())) {
                value = value.setOriginalValue(PlayerUtils.getPlayerSkin(profile));
            }
            if (PlayerUtils.areSkinPropertiesEquals(value.value(), PlayerUtils.getPlayerSkin(profile))) continue;
            if (save) {
                SkinRestorer.getSkinStorage().setSkin(profile.getId(), value);
            }
            PlayerUtils.applyRestoredSkin(profile, value.value());
            class_3222 player = server.method_3760().method_14602(profile.getId());
            if (player == null) continue;
            PlayerUtils.refreshPlayer(player);
            acceptedPlayers.add(player);
            SkinRestorer.getTickedScheduler().cancel(player.method_5667());
        }
        return acceptedPlayers;
    }

    public static Collection<class_3222> applySkin(MinecraftServer server, Iterable<GameProfile> targets, SkinValue value) {
        return SkinRestorer.applySkin(server, targets, value, true);
    }

    public static CompletableFuture<Result<Collection<class_3222>, String>> setSkinAsync(MinecraftServer server, Collection<GameProfile> targets, SkinProviderContext context, boolean save) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> SkinRestorer.getProvider(context.name()).map(provider -> provider.fetchSkin(context.argument(), context.variant()))).thenApplyAsync(result -> {
            if (result.isEmpty()) {
                return Result.error("provider '" + context.name() + "' is not registered");
            }
            Result skinResult = (Result)result.get();
            if (skinResult.isError()) {
                throw new TransparentException(Throwables.getRootCause((Throwable)((Throwable)skinResult.getErrorValue())));
            }
            SkinValue skinValue = SkinValue.fromProviderContextWithValue(context, ((Optional)skinResult.getSuccessValue()).orElse(null));
            Collection<class_3222> acceptedPlayers = SkinRestorer.applySkin(server, targets, skinValue, save);
            return Result.success(acceptedPlayers);
        }, (Executor)server)).exceptionally(e -> {
            LOGGER.error("Failed to set skin '{}:{}'", new Object[]{context.name(), context.argument(), e});
            return Result.error(e.getMessage());
        });
    }

    public static class Events {
        private Events() {
        }

        public static void onServerStarted(MinecraftServer server) {
            Path worldSkinDirectory = server.method_27050(class_5218.field_24188).resolve(SkinRestorer.MOD_ID);
            FileUtils.tryMigrateOldSkinDirectory(SkinRestorer.getConfigDir(), worldSkinDirectory);
            skinStorage = new SkinStorage(new SkinIO(worldSkinDirectory));
            tickedScheduler = new TickedScheduler(server);
            server.method_3742((Runnable)tickedScheduler);
            minecraftServer = server;
        }

        public static void onServerStopped(MinecraftServer server) {
            skinStorage = null;
            tickedScheduler = null;
            minecraftServer = null;
        }

        public static void onCommandRegister(CommandDispatcher<class_2168> dispatcher) {
            SkinCommand.register(dispatcher);
        }

        public static void onPlayerDisconnect(class_3222 player) {
            SkinRestorer.getSkinStorage().removeSkin(player.method_5667());
        }
    }
}

