/*
 * Decompiled with CFR 0.152.
 */
package org.TNTStudios.fakenameportfabric.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.TNTStudios.fakenameportfabric.FakeName;

public class FakeNameStorage {
    private static final Gson GSON = new Gson();
    private static final Type MAP_TYPE = new TypeToken<ConcurrentHashMap<UUID, String>>(){}.getType();
    private static final String FILE_NAME = "fakename_data.json";
    private static File dataFile;
    private static ConcurrentHashMap<UUID, String> fakeNames;

    public static void initialize(MinecraftServer server) {
        File serverDirectory = server.method_3831();
        dataFile = new File(serverDirectory, FILE_NAME);
        FakeNameStorage.load();
    }

    private static void load() {
        if (!dataFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(dataFile);){
            fakeNames = (ConcurrentHashMap)GSON.fromJson((Reader)reader, MAP_TYPE);
            if (fakeNames == null) {
                fakeNames = new ConcurrentHashMap();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(dataFile);){
            GSON.toJson(fakeNames, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setFakeName(class_3222 player, String fakeName) {
        fakeNames.put(player.method_5667(), fakeName);
        FakeName.setFakeName(player, fakeName);
        FakeNameStorage.save();
    }

    public static String getFakeName(class_3222 player) {
        return fakeNames.getOrDefault(player.method_5667(), player.method_5820());
    }

    public static void clearFakeName(class_3222 player) {
        fakeNames.remove(player.method_5667());
        FakeName.setFakeName(player, player.method_5820());
        FakeNameStorage.save();
    }

    static {
        fakeNames = new ConcurrentHashMap();
    }
}

