/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.INBTSerializable;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class SimpleContainer
implements class_1263,
INBTSerializable<class_2487> {
    private int size;
    private class_2371<class_1799> items;
    private List<class_1265> listeners;

    public SimpleContainer(int size) {
        this.size = size;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public SimpleContainer(class_1799 ... content) {
        this.size = content.length;
        this.items = class_2371.method_10212((Object)class_1799.field_8037, (Object[])content);
    }

    public void addListener(class_1265 param0) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(param0);
    }

    public void removeListener(class_1265 param0) {
        this.listeners.remove(param0);
    }

    @NotNull
    public class_1799 method_5438(int index) {
        return index >= 0 && index < this.items.size() ? (class_1799)this.items.get(index) : class_1799.field_8037;
    }

    public List<class_1799> removeAllItems() {
        List<class_1799> list = this.items.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList());
        this.method_5448();
        return list;
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        class_1799 removeResult = class_1262.method_5430(this.items, (int)index, (int)count);
        if (!removeResult.method_7960()) {
            this.method_5431();
        }
        return removeResult;
    }

    public class_1799 removeItemType(class_1792 item, int toExtract) {
        class_1799 nullStack = new class_1799((class_1935)item, 0);
        for (int reversedIndex = this.size - 1; reversedIndex >= 0; --reversedIndex) {
            class_1799 stack = this.method_5438(reversedIndex);
            if (!stack.method_7909().equals(item)) continue;
            int remaining = toExtract - nullStack.method_7947();
            class_1799 splitResult = stack.method_7971(remaining);
            nullStack.method_7933(splitResult.method_7947());
            if (nullStack.method_7947() == toExtract) break;
        }
        if (!nullStack.method_7960()) {
            this.method_5431();
        }
        return nullStack;
    }

    public class_1799 addItem(class_1799 input) {
        class_1799 var0 = input.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(var0);
        if (var0.method_7960()) {
            return class_1799.field_8037;
        }
        this.moveItemToEmptySlots(var0);
        return var0.method_7960() ? class_1799.field_8037 : var0;
    }

    public boolean canAddItem(class_1799 input) {
        boolean foundEmptyOrMatching = false;
        for (class_1799 stack : this.items) {
            if (!stack.method_7960() && (!class_1799.method_31577((class_1799)stack, (class_1799)input) || stack.method_7947() >= stack.method_7914())) continue;
            foundEmptyOrMatching = true;
            break;
        }
        return foundEmptyOrMatching;
    }

    @NotNull
    public class_1799 method_5441(int index) {
        class_1799 stack = (class_1799)this.items.get(index);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        this.items.set(index, (Object)class_1799.field_8037);
        return stack;
    }

    public void method_5447(int index, class_1799 stack) {
        this.items.set(index, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    public void method_5431() {
        if (this.listeners != null) {
            this.listeners.forEach(listener -> listener.method_5453((class_1263)this));
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public void fillStackedContents(class_1662 stackedContents) {
        for (class_1799 stack : this.items) {
            stackedContents.method_7400(stack);
        }
    }

    public String toString() {
        return this.items.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(class_1799 input) {
        for (int index = 0; index < this.size; ++index) {
            class_1799 stack = this.method_5438(index);
            if (!stack.method_7960()) continue;
            this.method_5447(index, input.method_7972());
            input.method_7939(0);
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 input) {
        for (int index = 0; index < this.size; ++index) {
            class_1799 stack = this.method_5438(index);
            if (!class_1799.method_31577((class_1799)stack, (class_1799)input)) continue;
            this.moveItemsBetweenStacks(input, stack);
            if (!input.method_7960()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(class_1799 leftInput, class_1799 rightInput) {
        int maxTransfer = Math.min(this.method_5444(), rightInput.method_7914());
        int toTransfer = Math.min(leftInput.method_7947(), maxTransfer - rightInput.method_7947());
        if (toTransfer > 0) {
            rightInput.method_7933(toTransfer);
            leftInput.method_7934(toTransfer);
            this.method_5431();
        }
    }

    public void fromTag(class_2499 param0) {
        for (int var0 = 0; var0 < param0.size(); ++var0) {
            class_1799 var1 = class_1799.method_7915((class_2487)param0.method_10602(var0));
            if (var1.method_7960()) continue;
            this.addItem(var1);
        }
    }

    public class_2499 createTag() {
        class_2499 var0 = new class_2499();
        for (int var1 = 0; var1 < this.method_5439(); ++var1) {
            class_1799 var2 = this.method_5438(var1);
            if (var2.method_7960()) continue;
            var0.add((Object)var2.method_7953(new class_2487()));
        }
        return var0;
    }

    public void setSize(int size) {
        this.size = size;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        this.method_5431();
    }

    @Override
    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.items.get(i)).method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.items.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.items.size());
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
        }
        this.method_5431();
    }
}

