/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleObjectCache<T> {
    @Nullable
    private T value;
    @NotNull
    private final Supplier<T> builder;
    @NotNull
    private final Function<T, T> cloner;

    public SingleObjectCache(@NotNull Supplier<T> builder, @NotNull Function<T, T> cloner) {
        this.builder = builder;
        this.cloner = cloner;
    }

    public T get() {
        if (this.value == null) {
            this.value = this.builder.get();
        }
        return this.cloner.apply(this.value);
    }

    public void reset() {
        this.value = null;
    }
}

