/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.network.packets.ModPacket;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class RequestChangeTrackerOperationPacket
extends ModPacket {
    private boolean redo;

    public RequestChangeTrackerOperationPacket(class_2540 byteBuf) {
        this.readPayload(byteBuf);
    }

    public RequestChangeTrackerOperationPacket(boolean redo) {
        this.redo = redo;
    }

    @Override
    public void writePayload(class_2540 buffer) {
        buffer.writeBoolean(this.redo);
    }

    @Override
    public void readPayload(class_2540 buffer) {
        this.redo = buffer.readBoolean();
    }

    @Override
    public void server(class_3222 playerEntity) {
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((class_1657)playerEntity);
        if (this.redo) {
            if (!tracker.canRedo((class_1657)playerEntity)) {
                playerEntity.method_43496((class_2561)LocalStrings.CanNotRedo.getText().method_27692(class_124.field_1061));
                return;
            }
            try {
                tracker.redo((class_1657)playerEntity);
                playerEntity.method_43496((class_2561)LocalStrings.RedoSuccessful.getText().method_27692(class_124.field_1060));
            }
            catch (IllegalChangeAttempt e) {
                playerEntity.method_43496((class_2561)LocalStrings.CanNotRedo.getText().method_27692(class_124.field_1061));
            }
            return;
        }
        if (!tracker.canUndo((class_1657)playerEntity)) {
            playerEntity.method_43496((class_2561)LocalStrings.CanNotUndo.getText().method_27692(class_124.field_1061));
            return;
        }
        try {
            tracker.undo((class_1657)playerEntity);
            playerEntity.method_43496((class_2561)LocalStrings.UndoSuccessful.getText().method_27692(class_124.field_1060));
        }
        catch (IllegalChangeAttempt e) {
            playerEntity.method_43496((class_2561)LocalStrings.CanNotUndo.getText().method_27692(class_124.field_1061));
        }
    }
}

