/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.mutator;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessorWithVoxelShape;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.ISingleStateAreaShareIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.multistate.snapshot.SimpleSnapshot;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class ChiselAdaptingWorldMutator
implements IWorldAreaMutator,
IAreaAccessorWithVoxelShape {
    public static final BlockInformation DEFAULT_STATE = new BlockInformation(class_2246.field_10340.method_9564(), Optional.empty());
    private final class_1936 world;
    private final class_2338 pos;

    public ChiselAdaptingWorldMutator(class_1936 world, class_2338 pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        if (this.getWorld().method_31606(this.getPos())) {
            return new PreAdaptedShapeIdentifier(this.getWorld().method_8320(this.getPos()));
        }
        class_2586 tileEntity = this.getWorld().method_8321(this.getPos());
        if (tileEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)tileEntity).createNewShapeIdentifier();
        }
        return new PreAdaptedShapeIdentifier(this.getWorld().method_8320(this.getPos()));
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        if (this.getWorld().method_31606(this.getPos())) {
            return Stream.empty();
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.stream();
        }
        class_2680 currentState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) || currentState.method_26215()) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        if (this.getWorld().method_31606(this.getPos())) {
            return Optional.empty();
        }
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0) {
            return Optional.empty();
        }
        if (inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            return Optional.empty();
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.getInAreaTarget(inAreaTarget);
        }
        class_2680 currentState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        return Optional.of(new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (class_2382)VectorUtils.toBlockPos(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())), this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(class_243 inAreaTarget) {
        if (this.getWorld().method_31606(this.getPos())) {
            return false;
        }
        return !(inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0);
    }

    @Override
    public boolean isInside(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        if (this.getWorld().method_31606(this.getPos())) {
            return EmptySnapshot.INSTANCE;
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.createSnapshot();
        }
        class_2680 currentState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        return new SimpleSnapshot(blockInformation);
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        block6: {
            BlockInformation blockInformation;
            block5: {
                if (this.getWorld().method_31606(this.getPos())) {
                    return Stream.empty();
                }
                class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
                if (blockEntity instanceof IMultiStateBlockEntity) {
                    IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
                    return multiStateBlockEntity.streamWithPositionMutator(positionMutator);
                }
                class_2680 currentState = this.getWorld().method_8320(this.getPos());
                Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
                blockInformation = new BlockInformation(currentState, additionalStateInfo);
                if (IEligibilityManager.getInstance().canBeChiseled(blockInformation)) break block5;
                if (!currentState.method_26215()) break block6;
            }
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        if (this.getWorld().method_31606(this.getPos())) {
            return;
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            multiStateBlockEntity.forEachWithPositionMutator(positionMutator, consumer);
        }
        class_2680 currentState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) || currentState.method_26215()) {
            BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
                class_2382 target = positionMutator.mutate((class_2382)blockPos);
                consumer.accept(new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), target, this::setInAreaTarget, this::clearInAreaTarget));
            });
        }
    }

    @Override
    public class_1936 getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public class_243 getInWorldStartPoint() {
        return class_243.method_24954((class_2382)this.pos);
    }

    @Override
    public class_243 getInWorldEndPoint() {
        return class_243.method_24954((class_2382)this.pos).method_1031((double)(15.0f * StateEntrySize.current().getSizePerBit()), (double)(15.0f * StateEntrySize.current().getSizePerBit()), (double)(15.0f * StateEntrySize.current().getSizePerBit()));
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        if (this.getWorld().method_31606(this.getPos())) {
            return Stream.empty();
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.mutableStream();
        }
        class_2680 currentState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation)) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, class_243 inAreaTarget) throws SpaceOccupiedException {
        Optional<IStateVariant> stateVariant;
        if (this.getWorld().method_31606(this.getPos())) {
            return;
        }
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset greater or equal to 0. Requested was: " + String.valueOf(inAreaTarget));
        }
        if (inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset smaller then 1. Requested was: " + String.valueOf(inAreaTarget));
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            multiStateBlockEntity.setInAreaTarget(blockInformation, inAreaTarget);
            return;
        }
        class_2680 blockState = this.getWorld().method_8320(this.getPos());
        BlockInformation newBlockInformation = new BlockInformation(blockState, stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity)));
        if (!newBlockInformation.isAir()) {
            throw new SpaceOccupiedException();
        }
        Optional<class_2248> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(blockInformation.getBlockState());
        if (optionalWithConvertedBlock.isPresent()) {
            class_2248 convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().method_8652(this.getPos(), convertedBlock.method_9564(), 3);
            class_2586 convertedTileEntity = this.getWorld().method_8321(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)convertedTileEntity;
                multiStateBlockEntity.initializeWith(newBlockInformation);
                multiStateBlockEntity.setInAreaTarget(blockInformation, inAreaTarget);
                return;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + String.valueOf(newBlockInformation) + " into a chiseled variant failed.");
        }
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(class_243 inAreaTarget) {
        Optional<IStateVariant> stateVariant;
        if (this.getWorld().method_31606(this.getPos())) {
            return;
        }
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset greater or equal to 0. Requested was: " + String.valueOf(inAreaTarget));
        }
        if (inAreaTarget.method_10216() > 1.0 || inAreaTarget.method_10214() > 1.0 || inAreaTarget.method_10215() > 1.0) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate blocks with an in area offset smaller then 1. Requested was: " + String.valueOf(inAreaTarget));
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            multiStateBlockEntity.clearInAreaTarget(inAreaTarget);
            return;
        }
        class_2680 blockState = this.getWorld().method_8320(this.getPos());
        BlockInformation newBlockInformation = new BlockInformation(blockState, stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity)));
        if (newBlockInformation.isAir()) {
            return;
        }
        Optional<class_2248> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(newBlockInformation.getBlockState());
        if (optionalWithConvertedBlock.isPresent()) {
            class_2248 convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().method_8652(this.getPos(), convertedBlock.method_9564(), 3);
            class_2586 convertedTileEntity = this.getWorld().method_8321(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)convertedTileEntity;
                multiStateBlockEntity.initializeWith(newBlockInformation);
                multiStateBlockEntity.clearInAreaTarget(inAreaTarget);
                return;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + String.valueOf(newBlockInformation) + " into a chiseled variant failed.");
        }
    }

    @Override
    public void clearInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalArgumentException("The chisel adapting world mutator can only mutate the given single block!");
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        if (this.getWorld().method_31606(this.getPos())) {
            return Stream.empty();
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.inWorldMutableStream();
        }
        class_2680 currentState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(currentState, Optional.ofNullable(blockEntity));
        BlockInformation blockInformation = new BlockInformation(currentState, additionalStateInfo);
        if (IEligibilityManager.getInstance().canBeChiseled(blockInformation) || currentState.method_26215()) {
            return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new MutablePreAdaptedStateEntry(blockInformation, this.getWorld(), this.getPos(), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        }
        return Stream.empty();
    }

    @Override
    public IBatchMutation batch() {
        BlockInformation currentState;
        if (this.getWorld().method_31606(this.getPos())) {
            return () -> {};
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            return ((IMultiStateBlockEntity)blockEntity).batch();
        }
        class_2680 blockState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity));
        IBlockInformation initializationState = currentState = new BlockInformation(blockState, stateVariant);
        if (currentState.isAir()) {
            currentState = DEFAULT_STATE;
            initializationState = BlockInformation.AIR;
        }
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState) && !currentState.isAir()) {
            return () -> {};
        }
        Optional<class_2248> optionalWithConvertedBlock = IConversionManager.getInstance().getChiseledVariantOf(currentState.getBlockState());
        if (optionalWithConvertedBlock.isPresent()) {
            class_2248 convertedBlock = optionalWithConvertedBlock.get();
            this.getWorld().method_8652(this.getPos(), convertedBlock.method_9564(), 3);
            class_2586 convertedTileEntity = this.getWorld().method_8321(this.getPos());
            if (convertedTileEntity instanceof IMultiStateBlockEntity) {
                IBatchMutation batchMutation = ((IMultiStateBlockEntity)convertedTileEntity).batch();
                ((IMultiStateBlockEntity)convertedTileEntity).initializeWith(initializationState);
                return batchMutation;
            }
            throw new IllegalStateException("Conversion of the existing block of type: " + String.valueOf(currentState) + " into a chiseled variant failed.");
        }
        return () -> {};
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        if (this.getWorld().method_31606(this.getPos())) {
            return () -> {};
        }
        class_2680 blockState = this.getWorld().method_8320(this.getPos());
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        Optional<IStateVariant> stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity));
        BlockInformation currentState = new BlockInformation(blockState, stateVariant);
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState) && !currentState.isAir()) {
            return () -> {};
        }
        IBatchMutation innerMutation = this.batch();
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateSnapshot before = ((IMultiStateBlockEntity)blockEntity).createSnapshot();
            return () -> {
                IMultiStateSnapshot after = ((IMultiStateBlockEntity)blockEntity).createSnapshot();
                innerMutation.close();
                changeTracker.onBlockUpdated(this.getPos(), before, after);
            };
        }
        return innerMutation;
    }

    @Override
    public class_265 provideShape(CollisionType type, class_2338 offset, boolean simplify) {
        if (this.getWorld().method_31606(this.getPos())) {
            return class_259.method_1073();
        }
        class_2586 blockEntity = this.getWorld().method_8321(this.getPos());
        if (blockEntity instanceof IMultiStateBlockEntity) {
            IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
            return multiStateBlockEntity.provideShape(type, offset, simplify);
        }
        class_2680 blockState = this.getWorld().method_8320(this.getPos());
        Optional<IStateVariant> stateVariant = IStateVariantManager.getInstance().getStateVariant(blockState, Optional.ofNullable(blockEntity));
        BlockInformation currentState = new BlockInformation(blockState, stateVariant);
        if (!IEligibilityManager.getInstance().canBeChiseled(currentState) && !currentState.isAir()) {
            return class_259.method_1073();
        }
        if (currentState.isAir() && type.isValidFor(currentState.getBlockState())) {
            return class_259.method_1077().method_1096((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260());
        }
        return currentState.getBlockState().method_26218((class_1922)this.getWorld(), this.getPos()).method_1096((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260());
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238((double)this.getPos().method_10263(), (double)this.getPos().method_10264(), (double)this.getPos().method_10260(), (double)(this.getPos().method_10263() + 1), (double)(this.getPos().method_10264() + 1), (double)(this.getPos().method_10260() + 1));
    }

    private static class PreAdaptedShapeIdentifier
    implements ISingleStateAreaShareIdentifier {
        private final int blockState;

        private PreAdaptedShapeIdentifier(class_2680 blockState) {
            this.blockState = IBlockStateIdManager.getInstance().getIdFrom(blockState);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PreAdaptedShapeIdentifier)) {
                return false;
            }
            PreAdaptedShapeIdentifier that = (PreAdaptedShapeIdentifier)o;
            return this.blockState == that.blockState;
        }

        public int hashCode() {
            return Objects.hash(this.blockState);
        }
    }

    private static class MutablePreAdaptedStateEntry
    implements IInWorldMutableStateEntryInfo {
        private final IBlockInformation blockInformation;
        private final class_1936 world;
        private final class_243 startPoint;
        private final class_243 endPoint;
        private final class_2338 blockPos;
        private final StateSetter setCallback;
        private final StateClearer clearCallback;

        public MutablePreAdaptedStateEntry(IBlockInformation blockInformation, class_1936 world, class_2338 blockPos, class_2382 inBlockOffset, StateSetter setCallback, StateClearer clearCallback) {
            this.blockInformation = blockInformation;
            this.world = world;
            this.blockPos = blockPos;
            this.startPoint = class_243.method_24954((class_2382)inBlockOffset).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            this.setCallback = setCallback;
            this.clearCallback = clearCallback;
            this.endPoint = this.startPoint.method_1031((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        }

        @Override
        @NotNull
        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        @NotNull
        public class_243 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public class_243 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public class_1936 getWorld() {
            return this.world;
        }

        @Override
        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        @Override
        public void setBlockInformation(IBlockInformation blockInformation) throws SpaceOccupiedException {
            this.setCallback.set(blockInformation, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.clearCallback.accept(this.getStartPoint());
        }
    }
}

