/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.measures;

import com.communi.suggestu.scena.core.dist.Dist;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.IMeasuringManager;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.measures.Measurement;
import mod.chiselsandbits.measures.MeasurementNetworkUtil;
import mod.chiselsandbits.network.packets.MeasurementsUpdatedPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class MeasuringManager
implements IMeasuringManager,
IPacketBufferSerializable {
    private static final MeasuringManager INSTANCE = new MeasuringManager();
    private final Table<class_2960, UUID, Map<MeasuringMode, Measurement>> measurements = HashBasedTable.create();

    public static MeasuringManager getInstance() {
        return INSTANCE;
    }

    private MeasuringManager() {
    }

    @Override
    public Collection<? extends IMeasurement> getInWorld(class_2960 worldKey) {
        return this.measurements.row((Object)worldKey).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    @Override
    public Collection<? extends IMeasurement> getForPlayer(UUID playerId) {
        return this.measurements.column((Object)playerId).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    @Override
    public Measurement create(class_1937 world, class_1657 playerEntity, class_243 from, class_243 to, class_2350 hitFace, MeasuringMode mode) {
        return new Measurement(playerEntity.method_5667(), from, to, hitFace, mode, world.method_27983().method_29177());
    }

    @Override
    public void resetMeasurementsFor(UUID playerId) {
        this.measurements.columnMap().remove(playerId);
        this.syncToAll();
    }

    public void syncToAll() {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToEveryone(new MeasurementsUpdatedPacket());
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        packetBuffer.method_10804(this.measurements.size());
        this.measurements.values().forEach(m -> {
            packetBuffer.method_10804(m.size());
            m.values().forEach(measurement -> measurement.serializeInto(packetBuffer));
        });
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.measurements.clear();
        List measurements = IntStream.range(0, packetBuffer.method_10816()).mapToObj(index -> {
            int measurementCount = packetBuffer.method_10816();
            ArrayList measurementList = Lists.newArrayList();
            for (int i = 0; i < measurementCount; ++i) {
                Measurement measurement = new Measurement();
                measurement.deserializeFrom(packetBuffer);
                measurementList.add(measurement);
            }
            return measurementList;
        }).flatMap(Collection::stream).toList();
        measurements.forEach(measurement -> {
            if (!this.measurements.contains((Object)measurement.getWorldKey(), (Object)measurement.getOwner())) {
                this.measurements.put((Object)measurement.getWorldKey(), (Object)measurement.getOwner(), new HashMap());
            }
            ((Map)this.measurements.get((Object)measurement.getWorldKey(), (Object)measurement.getOwner())).put(measurement.getMode(), measurement);
        });
    }

    public void addOrUpdate(Measurement measurement) {
        if (!this.measurements.contains((Object)measurement.getWorldKey(), (Object)measurement.getOwner())) {
            this.measurements.put((Object)measurement.getWorldKey(), (Object)measurement.getOwner(), new HashMap());
        }
        ((Map)this.measurements.get((Object)measurement.getWorldKey(), (Object)measurement.getOwner())).put(measurement.getMode(), measurement);
        this.syncToAll();
    }

    public void createAndSend(class_243 from, class_243 to, class_2350 hitFace, MeasuringMode mode) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MeasurementNetworkUtil.createAndSend(from, to, hitFace, mode));
    }
}

