/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.inventory.bit.SlottedBitInventory;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class SlottedBitInventoryItemStack
extends SlottedBitInventory
implements IBitInventoryItemStack {
    private final Function<class_2487, class_1799> saveBuilder;

    public SlottedBitInventoryItemStack(int size, Function<class_2487, class_1799> saveBuilder) {
        super(size);
        this.saveBuilder = saveBuilder;
    }

    @Override
    public class_1799 toItemStack() {
        class_2487 compoundNBT = this.serializeNBT();
        return this.saveBuilder.apply(compoundNBT);
    }

    @Override
    public List<class_2561> listContents() {
        return this.getContents().stream().sorted(Comparator.comparingInt(SlottedBitInventory.BitSlot::getCount).reversed()).map(slot -> class_2561.method_43469((String)"chiselsandbits.bitbag.contents.enum.entry", (Object[])new Object[]{slot.getCount(), slot.getBlockInformation().getBlockState().method_26204().method_9518()})).collect(Collectors.toList());
    }

    @Override
    public double getFilledRatio() {
        return (double)this.slotMap.keySet().size() / (double)this.size;
    }

    @Override
    public void clear(IBlockInformation state) {
        Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.slotMap);
        this.slotMap.clear();
        int slotIndex = 0;
        for (SlottedBitInventory.BitSlot bitSlot : slots.values()) {
            if (bitSlot.getBlockInformation() == state) continue;
            this.slotMap.put(slotIndex, (Object)bitSlot);
            ++slotIndex;
        }
    }

    @Override
    public void sort() {
        HashMap contentMap = Maps.newHashMap();
        this.slotMap.values().forEach(bitSlot -> {
            contentMap.putIfAbsent(bitSlot.getBlockInformation(), 0);
            contentMap.compute(bitSlot.getBlockInformation(), (s, c) -> (c == null ? 0 : c) + bitSlot.getCount());
        });
        this.slotMap.clear();
        ArrayList toSort = new ArrayList(contentMap.entrySet());
        toSort.sort(Map.Entry.comparingByValue().reversed());
        int slotIndex = 0;
        for (Map.Entry entry : toSort) {
            int count = (Integer)entry.getValue();
            if (count == 0) continue;
            while (count > IServerConfiguration.getInstance().getBagStackSize().get() && count > 0) {
                this.slotMap.put(slotIndex, (Object)new SlottedBitInventory.BitSlot((IBlockInformation)entry.getKey(), IServerConfiguration.getInstance().getBagStackSize().get()));
                ++slotIndex;
                count -= IServerConfiguration.getInstance().getBagStackSize().get().intValue();
            }
            if (count <= 0) continue;
            this.slotMap.put(slotIndex, (Object)new SlottedBitInventory.BitSlot((IBlockInformation)entry.getKey(), count));
            ++slotIndex;
        }
    }

    public int method_5439() {
        return this.size;
    }

    @Override
    @NotNull
    public class_1799 method_5438(int index) {
        return super.method_5438(index);
    }

    @NotNull
    public class_1799 method_5434(int index, int count) {
        if (!this.slotMap.containsKey(index)) {
            return class_1799.field_8037;
        }
        SlottedBitInventory.BitSlot bitSlot = (SlottedBitInventory.BitSlot)this.slotMap.get(index);
        int containedCount = bitSlot.getCount();
        bitSlot.setCount(containedCount - count);
        if (bitSlot.getCount() <= 0) {
            this.slotMap.remove(index);
        }
        return IBitItemManager.getInstance().create(bitSlot.getBlockInformation(), Math.min(containedCount, count));
    }

    @NotNull
    public class_1799 method_5441(int index) {
        return this.method_5434(index, Integer.MAX_VALUE);
    }

    public void method_5447(int index, class_1799 stack) {
        if (stack.method_7960()) {
            this.slotMap.remove(index);
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IBitItem)) {
            return;
        }
        IBitItem bitItem = (IBitItem)class_17922;
        IBlockInformation state = bitItem.getBlockInformation(stack);
        SlottedBitInventory.BitSlot bitSlot = (SlottedBitInventory.BitSlot)this.slotMap.getOrDefault(index, (Object)new SlottedBitInventory.BitSlot());
        bitSlot.setBlockInformation(state);
        bitSlot.setCount(stack.method_7947());
        this.slotMap.put(index, (Object)bitSlot);
    }

    public void method_5431() {
        this.onChange();
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.slotMap.clear();
        this.onChange();
    }

    @Override
    protected void onChange() {
        super.onChange();
        this.toItemStack();
    }

    @Override
    protected int getMaxBitsForSlot() {
        return IServerConfiguration.getInstance().getBagStackSize().get();
    }

    public int method_5444() {
        return this.getMaxBitsForSlot();
    }

    @Override
    public boolean method_5442() {
        return super.method_5442();
    }
}

