/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class AbstractBitInventory
implements IBitInventory {
    protected AbstractBitInventory() {
    }

    @Override
    public boolean canExtract(IBlockInformation blockState, int count) {
        int contained = this.getMaxExtractAmount(blockState);
        return count <= contained;
    }

    @Override
    public int getMaxExtractAmount(IBlockInformation blockState) {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::method_5438).filter(stack -> stack.method_7909() instanceof IBitItem || stack.method_7909() instanceof IBitInventoryItem).mapToInt(stack -> {
            class_1792 patt2003$temp = stack.method_7909();
            if (patt2003$temp instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)patt2003$temp;
                if (bitItem.getBlockInformation((class_1799)stack).equals(blockState)) {
                    return stack.method_7947();
                }
                return 0;
            }
            class_1792 patt2279$temp = stack.method_7909();
            if (patt2279$temp instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)patt2279$temp;
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((class_1799)stack);
                return bitInventory.getMaxExtractAmount(blockState);
            }
            return 0;
        }).sum();
    }

    protected abstract class_1799 method_5438(int var1);

    protected abstract int getInventorySize();

    @Override
    public void extract(IBlockInformation blockInformation, int count) throws IllegalArgumentException {
        class_1799 stack;
        int i;
        if (!this.canExtract(blockInformation, count)) {
            throw new IllegalArgumentException("Can not extract: " + String.valueOf(blockInformation));
        }
        int toExtract = count;
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            stack = this.method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof IBitInventoryItem)) continue;
            IBitInventoryItem bitInventoryItem = (IBitInventoryItem)class_17922;
            IBitInventoryItemStack bitInventory = bitInventoryItem.create(stack);
            int inventoryExtractCount = Math.min(toExtract, bitInventory.getMaxExtractAmount(blockInformation));
            toExtract -= inventoryExtractCount;
            bitInventory.extract(blockInformation, inventoryExtractCount);
            class_1799 newStack = bitInventory.toItemStack();
            this.setSlotContents(i, newStack);
        }
        if (toExtract <= 0) {
            return;
        }
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            IBitItem bitItem;
            stack = this.method_5438(i);
            class_1792 bitInventory = stack.method_7909();
            if (!(bitInventory instanceof IBitItem) || !(bitItem = (IBitItem)bitInventory).getBlockInformation(stack).equals(blockInformation)) continue;
            int stackExtractCount = Math.min(toExtract, stack.method_7947());
            toExtract -= stackExtractCount;
            stack.method_7939(stack.method_7947() - stackExtractCount);
            this.setSlotContents(i, stack);
        }
    }

    protected abstract void setSlotContents(int var1, class_1799 var2);

    @Override
    public boolean canInsert(IBlockInformation blockState, int count) {
        int insertionCount = this.getMaxInsertAmount(blockState);
        return count <= insertionCount;
    }

    protected int getMaxBitsForSlot() {
        return IBitItemManager.getInstance().getMaxStackSize();
    }

    @Override
    public int getMaxInsertAmount(IBlockInformation blockInformation) {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::method_5438).filter(stack -> stack.method_7909() instanceof IBitItem || stack.method_7909() instanceof IBitInventoryItem || stack.method_7960()).mapToInt(stack -> {
            if (stack.method_7960()) {
                return this.getMaxBitsForSlot();
            }
            class_1792 patt6601$temp = stack.method_7909();
            if (patt6601$temp instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)patt6601$temp;
                if (bitItem.getBlockInformation((class_1799)stack).equals(blockInformation)) {
                    return this.getMaxBitsForSlot() - stack.method_7947();
                }
                return 0;
            }
            class_1792 patt6905$temp = stack.method_7909();
            if (patt6905$temp instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)patt6905$temp;
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((class_1799)stack);
                return bitInventory.getMaxInsertAmount(blockInformation);
            }
            return 0;
        }).sum();
    }

    @Override
    public void insert(IBlockInformation blockInformation, int count) throws IllegalArgumentException {
        Object bitInventory;
        int i;
        class_1792 newStack;
        class_1799 stack;
        if (!this.canInsert(blockInformation, count)) {
            throw new IllegalArgumentException("Can not insert: " + String.valueOf(blockInformation));
        }
        int currentRawCount = 0;
        for (int i2 = 0; i2 < this.getInventorySize(); ++i2) {
            IBitItem bitItem;
            class_1799 stack2 = this.method_5438(i2);
            class_1792 class_17922 = stack2.method_7909();
            if (!(class_17922 instanceof IBitItem) || !(bitItem = (IBitItem)class_17922).getBlockInformation(stack2).equals(blockInformation)) continue;
            currentRawCount += stack2.method_7947();
        }
        int toInsert = count;
        if (currentRawCount == 0) {
            for (int i3 = 0; i3 < this.getInventorySize(); ++i3) {
                int stackInsertCount;
                stack = this.method_5438(i3);
                if (stack.method_7960() && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot())) > 0) {
                    toInsert -= stackInsertCount;
                    newStack = IBitItemManager.getInstance().create(blockInformation, stackInsertCount);
                    this.setSlotContents(i3, (class_1799)newStack);
                    break;
                }
                if (toInsert > 0) continue;
                return;
            }
        }
        if (currentRawCount < this.getMaxBitsForSlot()) {
            for (int i4 = 0; i4 < this.getInventorySize(); ++i4) {
                int stackInsertCount;
                IBitItem bitItem;
                stack = this.method_5438(i4);
                newStack = stack.method_7909();
                if (newStack instanceof IBitItem && (bitItem = (IBitItem)newStack).getBlockInformation(stack).equals(blockInformation) && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot() - stack.method_7947())) > 0) {
                    toInsert -= stackInsertCount;
                    stack.method_7939(stack.method_7947() + stackInsertCount);
                    this.setSlotContents(i4, stack);
                }
                if (toInsert > 0) continue;
                return;
            }
        }
        for (i = this.getInventorySize() - 1; i >= 0; --i) {
            IBitInventoryItem bitInventoryItem;
            int inventoryInsertCount;
            stack = this.method_5438(i);
            class_1792 stackInsertCount = stack.method_7909();
            if (stackInsertCount instanceof IBitInventoryItem && (inventoryInsertCount = Math.min(toInsert, (bitInventory = (bitInventoryItem = (IBitInventoryItem)stackInsertCount).create(stack)).getMaxInsertAmount(blockInformation))) > 0) {
                toInsert -= inventoryInsertCount;
                bitInventory.insert(blockInformation, inventoryInsertCount);
                class_1799 newStack2 = bitInventory.toItemStack();
                this.setSlotContents(i, newStack2);
            }
            if (toInsert > 0) continue;
            return;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            int stackInsertCount;
            IBitItem bitItem;
            stack = this.method_5438(i);
            bitInventory = stack.method_7909();
            if (bitInventory instanceof IBitItem && (bitItem = (IBitItem)bitInventory).getBlockInformation(stack).equals(blockInformation) && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot() - stack.method_7947())) > 0) {
                toInsert -= stackInsertCount;
                stack.method_7939(stack.method_7947() + stackInsertCount);
                this.setSlotContents(i, stack);
            }
            if (toInsert > 0) continue;
            return;
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            int stackInsertCount;
            stack = this.method_5438(i);
            if (stack.method_7960() && (stackInsertCount = Math.min(toInsert, this.getMaxBitsForSlot())) > 0) {
                toInsert -= stackInsertCount;
                newStack = IBitItemManager.getInstance().create(blockInformation, stackInsertCount);
                this.setSlotContents(i, (class_1799)newStack);
            }
            if (toInsert > 0) continue;
            return;
        }
    }

    @Override
    public Map<IBlockInformation, Integer> getContainedStates() {
        return IntStream.range(0, this.getInventorySize()).mapToObj(this::method_5438).filter(stack -> stack.method_7909() instanceof IBitItem || stack.method_7909() instanceof IBitInventoryItem).map(stack -> {
            class_1792 patt12380$temp = stack.method_7909();
            if (patt12380$temp instanceof IBitItem) {
                IBitItem bitItem = (IBitItem)patt12380$temp;
                return Maps.newHashMap((Map)ImmutableMap.of((Object)bitItem.getBlockInformation((class_1799)stack), (Object)stack.method_7947()));
            }
            class_1792 patt12581$temp = stack.method_7909();
            if (patt12581$temp instanceof IBitInventoryItem) {
                IBitInventoryItem bitInventoryItem = (IBitInventoryItem)patt12581$temp;
                IBitInventoryItemStack bitInventory = bitInventoryItem.create((class_1799)stack);
                return Maps.newHashMap(bitInventory.getContainedStates());
            }
            return Maps.newHashMap((Map)ImmutableMap.of());
        }).reduce(Maps.newHashMap(), (blockStateIntegerHashMap, blockStateIntegerHashMap2) -> {
            HashMap result = Maps.newHashMap((Map)blockStateIntegerHashMap);
            blockStateIntegerHashMap2.forEach((state, count) -> {
                if (!result.containsKey(state)) {
                    result.put(state, count);
                } else {
                    result.put(state, (Integer)result.get(state) + count);
                }
            });
            return result;
        });
    }
}

