/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.fabric.plugin.asm;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.launch.ILaunchPropertyManager;
import mod.chiselsandbits.api.plugin.IPluginDiscoverer;
import mod.chiselsandbits.api.plugin.PluginData;
import mod.chiselsandbits.api.util.ClassUtils;
import mod.chiselsandbits.api.util.GroupingUtils;
import mod.chiselsandbits.fabric.plugin.asm.AnnotationData;
import mod.chiselsandbits.fabric.plugin.asm.ModClassVisitor;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricPluginDiscoverer
implements IPluginDiscoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricPluginDiscoverer.class);

    @Override
    public <A, I extends Annotation, T> Collection<PluginData<T>> loadPlugins(Class<A> annotationType, Class<I> instanceAnnotationType, Class<T> pluginSpecificationType, Function<T, String> idExtractor) {
        HashSet pluginCandidates = Sets.newHashSet();
        for (Object allMod : FabricLoader.getInstance().getAllMods()) {
            for (Path rootPath : allMod.getRootPaths()) {
                AccumulatorPathVisitor visitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), (PathFilter)new AbstractFileFilter(){

                    public FileVisitResult accept(Path path, BasicFileAttributes attributes) {
                        return path.getFileName().toString().endsWith(".class") ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
                    }
                }, (PathFilter)TrueFileFilter.TRUE);
                try {
                    Files.walkFileTree(rootPath, (FileVisitor<? super Path>)visitor);
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to discover plugins from path: %s".formatted(rootPath), (Throwable)e);
                    continue;
                }
                List classFiles = visitor.getFileList();
                for (Path classFile : classFiles) {
                    ClassReader reader;
                    try {
                        reader = new ClassReader(Files.newInputStream(classFile, new OpenOption[0]));
                    }
                    catch (IOException e) {
                        LOGGER.debug("Failed to read class for plugin detection: %s".formatted(classFile.toAbsolutePath()), (Throwable)e);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.warn("Failed to read class for plugin detection, it has an unsupported ASM Version: %s".formatted(classFile.toAbsolutePath()), (Throwable)iae);
                        continue;
                    }
                    ModClassVisitor modClassVisitor = new ModClassVisitor();
                    reader.accept((ClassVisitor)modClassVisitor, 7);
                    Set<AnnotationData> annotationData = modClassVisitor.annotationData();
                    for (AnnotationData data : annotationData) {
                        if (!data.annotationType().getClassName().equals(annotationType.getName())) continue;
                        pluginCandidates.add(new DiscoveredPlugin(data.annotationData(), data.clazz().getClassName()));
                    }
                }
            }
        }
        ArrayList<PluginData<T>> plugins = new ArrayList<PluginData<T>>();
        for (DiscoveredPlugin pluginCandidate : pluginCandidates) {
            T plugin;
            Boolean isExperimental;
            ArrayList requiredMods = (ArrayList)pluginCandidate.annotationData().get("requiredMods");
            if (requiredMods != null && requiredMods.size() > 0 && requiredMods.stream().anyMatch(modId -> !FabricLoader.getInstance().isModLoaded(modId)) || (isExperimental = (Boolean)pluginCandidate.annotationData().get("isExperimental")) != null && isExperimental.booleanValue() && !Boolean.parseBoolean(ILaunchPropertyManager.getInstance().get("plugins.experimental", "false")) || (plugin = FabricPluginDiscoverer.createPluginFrom(pluginCandidate.className(), pluginSpecificationType, instanceAnnotationType, idExtractor)) == null) continue;
            plugins.add(new PluginData<T>(plugin, isExperimental != null && isExperimental != false));
            LOGGER.info("Found and loaded ChiselsAndBits plugin: {}", (Object)idExtractor.apply(plugin));
        }
        Collection<Collection<T>> groupedByIds = GroupingUtils.groupByUsingSet(plugins.stream().map(PluginData::plugin).collect(Collectors.toList()), idExtractor);
        Collection idsWithDuplicates = groupedByIds.stream().filter(p -> p.size() > 1).map(p -> p.iterator().next()).map(idExtractor).collect(Collectors.toSet());
        if (idsWithDuplicates.size() > 0) {
            throw new RuntimeException(String.format("Can not load C&B there are multiple instances of the plugins: [%s]", String.join((CharSequence)", ", idsWithDuplicates)));
        }
        return ImmutableSet.copyOf(plugins);
    }

    @Nullable
    private static <T, I extends Annotation> T createPluginFrom(String className, Class<T> pluginSpecificationType, Class<I> instanceAnnotationType, Function<T, String> idExtractor) {
        return ClassUtils.createOrGetInstance(className, pluginSpecificationType, instanceAnnotationType, idExtractor);
    }

    private record DiscoveredPlugin(Map<String, Object> annotationData, String className) {
    }
}

