/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import mod.chiselsandbits.api.profiling.IProfilingManager;
import mod.chiselsandbits.api.util.BlockInformationUtils;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.network.packets.ExportPatternCommandMessagePacket;
import mod.chiselsandbits.network.packets.ImportPatternCommandMessagePacket;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.CommandUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_6506;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandManager {
    private static final CommandManager INSTANCE = new CommandManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleCommandExceptionType GIVE_NOT_CHISELABLE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)LocalStrings.CommandGiveErrorBlockStateNotChiselable.toString()));

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        return INSTANCE;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 pContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"candb").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"fill").then(class_2170.method_9244((String)"start", (ArgumentType)class_2277.method_9735((boolean)false)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"end", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"state", (ArgumentType)class_2257.method_9653((class_7157)pContext)).executes(this::runFillCommand))).then(class_2170.method_9247((String)"random").executes(this::runFillCommand)))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"start", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"end", (ArgumentType)class_2277.method_9735((boolean)false)).executes(this::runClearCommand))))).then(class_2170.method_9247((String)"stats").then(class_2170.method_9244((String)"start", (ArgumentType)class_2277.method_9735((boolean)false)).then(class_2170.method_9244((String)"end", (ArgumentType)class_2277.method_9735((boolean)false)).executes(this::runStatsCommand))))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"state", (ArgumentType)class_2257.method_9653((class_7157)pContext)).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4096)).executes(this::runGiveCommand))).executes(this::runGiveCommand))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"profiling").then(class_2170.method_9247((String)"start").executes(this::startProfiling))).then(class_2170.method_9247((String)"stop").executes(this::stopProfiling)))).then(class_2170.method_9247((String)"undo").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::undoFor)))).then(class_2170.method_9247((String)"redo").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::redoFor)))).then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)"target", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::savePatternOf))))).then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::loadPatternOf))));
    }

    private int runFillCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_243 start = class_2277.method_9736(context, (String)"start");
        class_243 end = class_2277.method_9736(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((class_1936)((class_2168)context.getSource()).method_9225(), start, end);
        if (CommandUtils.hasArgument(context, "state")) {
            class_2680 state = class_2257.method_9655(context, (String)"state").method_9494();
            try (IBatchMutation ignored = ((class_2168)context.getSource()).method_9228() != null ? mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker((class_1657)((class_2168)context.getSource()).method_9207())) : mutator.batch();){
                mutator.mutableStream().forEach(entry -> entry.overrideState(new BlockInformation(state, Optional.empty())));
            }
        }
        try (IBatchMutation ignored = ((class_2168)context.getSource()).method_9228() != null ? mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker((class_1657)((class_2168)context.getSource()).method_9207())) : mutator.batch();){
            mutator.mutableStream().forEach(entry -> entry.overrideState(BlockInformationUtils.getRandomSupportedInformation(((class_2168)context.getSource()).method_9225().method_8409())));
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)LocalStrings.CommandFillCompleted.toString()), true);
        return 0;
    }

    private int runClearCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_243 start = class_2277.method_9736(context, (String)"start");
        class_243 end = class_2277.method_9736(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((class_1936)((class_2168)context.getSource()).method_9225(), start, end);
        try (IBatchMutation ignored = ((class_2168)context.getSource()).method_9228() != null ? mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker((class_1657)((class_2168)context.getSource()).method_9207())) : mutator.batch();){
            mutator.mutableStream().forEach(IMutableStateEntryInfo::clear);
        }
        return 0;
    }

    private int runStatsCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_243 start = class_2277.method_9736(context, (String)"start");
        class_243 end = class_2277.method_9736(context, (String)"end");
        IWorldAreaMutator mutator = IMutatorFactory.getInstance().covering((class_1936)((class_2168)context.getSource()).method_9225(), start, end);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Collected the following statistics for the requested area:"), true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"----------------------------------------------------------"), true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"BlockStates:"), true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"############"), true);
        mutator.createSnapshot().getStatics().getStateCounts().forEach((state, count) -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)" > ").method_10852((class_2561)state.getBlockState().method_26204().method_9518()).method_10852((class_2561)class_2561.method_43470((String)(": " + count))), true));
        return 0;
    }

    private int runGiveCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"target");
        class_2680 state = class_2257.method_9655(context, (String)"state").method_9494();
        BlockInformation information = new BlockInformation(state, IStateVariantManager.getInstance().getStateVariant(state, Optional.empty()));
        if (!IEligibilityManager.getInstance().canBeChiseled(information)) {
            throw GIVE_NOT_CHISELABLE_EXCEPTION.create();
        }
        int count = CommandUtils.hasArgument(context, "count") ? IntegerArgumentType.getInteger(context, (String)"count") : 4096;
        IBitInventory inventory = IBitInventoryManager.getInstance().create((class_1657)target);
        int insertionCount = Math.min(inventory.getMaxInsertAmount(new BlockInformation(state, Optional.empty())), count);
        inventory.insertOrDiscard(new BlockInformation(state, Optional.empty()), insertionCount);
        return 0;
    }

    private int startProfiling(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (ProfilingManager.getInstance().hasProfiler()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Already profiling!"));
            return 1;
        }
        ProfilingManager.getInstance().setProfiler(IProfilingManager.getInstance().startProfiling(class_6506.method_37987((MinecraftServer)((class_2168)context.getSource()).method_9211())));
        return 0;
    }

    private int stopProfiling(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (!ProfilingManager.getInstance().hasProfiler()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Not yet profiling!"));
            return 1;
        }
        IProfilerResult result = IProfilingManager.getInstance().stopProfiling(ProfilingManager.getInstance().getProfiler());
        result.writeAsResponse(line -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)line), true));
        return 0;
    }

    private int redoFor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"target");
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((class_1657)target);
        if (tracker.getChanges().isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No changes available to redo"));
            return 1;
        }
        try {
            tracker.redo((class_1657)target);
            return 0;
        }
        catch (IllegalChangeAttempt e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Can not redo"));
            return 2;
        }
    }

    private int undoFor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"target");
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((class_1657)target);
        if (tracker.getChanges().isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No changes available to undo"));
            return 1;
        }
        try {
            tracker.undo((class_1657)target);
            return 0;
        }
        catch (IllegalChangeAttempt e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Can not undo"));
            return 2;
        }
    }

    private int savePatternOf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 target = class_2262.method_9696(context, (String)"target");
        String name = StringArgumentType.getString(context, (String)"name");
        ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(new ExportPatternCommandMessagePacket(target, name), ((class_2168)context.getSource()).method_9207());
        return 0;
    }

    private int loadPatternOf(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(new ImportPatternCommandMessagePacket(name), ((class_2168)context.getSource()).method_9207());
        return 0;
    }
}

