/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.clipboard;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import mod.chiselsandbits.api.client.clipboard.ICreativeClipboardManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.registrars.ModCreativeTabs;
import mod.chiselsandbits.utils.SimpleMaxSizedList;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_7708;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CreativeClipboardManager
implements ICreativeClipboardManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CreativeClipboardManager INSTANCE = new CreativeClipboardManager();
    private final SimpleMaxSizedList<IMultiStateItemStack> cache = new SimpleMaxSizedList(IClientConfiguration.getInstance().getClipboardSize());

    public static CreativeClipboardManager getInstance() {
        return INSTANCE;
    }

    private CreativeClipboardManager() {
    }

    public void load() {
        File file = new File("chiselsandbits/clipboard.dat");
        if (!file.exists()) {
            return;
        }
        this.cache.clear();
        try {
            class_2487 data = class_2507.method_30613((File)file);
            class_2499 tags = data.method_10554("clipboard", 10);
            tags.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).map(class_1799::method_7915).map(SingleBlockMultiStateItemStack::new).forEach(this.cache::add);
        }
        catch (IOException e) {
            LOGGER.fatal("Failed to read a clipboard file!", (Throwable)e);
        }
    }

    private void writeContentsToDisk() {
        class_2487 data = new class_2487();
        class_2499 tags = new class_2499();
        this.cache.stream().map(IMultiStateItemStack::toBlockStack).map(stack -> stack.method_7953(new class_2487())).forEach(arg_0 -> tags.add(arg_0));
        data.method_10566("clipboard", (class_2520)tags);
        File file = new File("chiselsandbits/clipboard.dat");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        } else {
            file.delete();
        }
        try {
            file.createNewFile();
            class_2507.method_30614((class_2487)data, (File)file);
        }
        catch (IOException e) {
            LOGGER.fatal("Failed to create a clipboard file!", (Throwable)e);
        }
    }

    private void updateCreativeTab() {
        try {
            ((class_1761)ModCreativeTabs.CLIPBOARD.get()).field_40859 = class_7708.method_47572();
            this.cache.forEach(stack -> ((class_1761)ModCreativeTabs.CLIPBOARD.get()).field_40859.add(stack.toBlockStack()));
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof class_481) {
                class_481 screen = (class_481)class_4372;
                screen.method_47421(this.cache.stream().map(IMultiStateItemStack::toBlockStack).toList());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to update creative tab", (Throwable)e);
        }
    }

    @Override
    public List<IMultiStateItemStack> getClipboard() {
        return ImmutableList.copyOf(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(IMultiStateItemStack multiStateItemStack) {
        SimpleMaxSizedList<IMultiStateItemStack> simpleMaxSizedList = this.cache;
        synchronized (simpleMaxSizedList) {
            if (this.cache.contains(multiStateItemStack)) {
                return;
            }
            this.cache.add(multiStateItemStack);
            this.writeContentsToDisk();
            this.updateCreativeTab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(int index) {
        SimpleMaxSizedList<IMultiStateItemStack> simpleMaxSizedList = this.cache;
        synchronized (simpleMaxSizedList) {
            if (index < 0 || index >= this.cache.size()) {
                return;
            }
            this.cache.remove(index);
            this.writeContentsToDisk();
            this.updateCreativeTab();
        }
    }
}

