/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.client.screen.widget.AbstractChiselsAndBitsWidget;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.withmode.IRenderableMode;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RadialSelectionWidget
extends AbstractChiselsAndBitsWidget {
    private static final float DRAWS = 720.0f;
    private final Supplier<IRenderableMode> currentlySelectedModeSupplier;
    private final Consumer<IRenderableMode> currentlyHoveredModeCallback;
    private final Consumer<IRenderableMode> currentlyClickedModeCallback;
    private final List<? extends IRenderableMode> modes;
    private final float sectionArcAngle;
    private final float sectionStartAngle;
    private final float innerSelectionRadius;
    private final float outerSelectionRadius;
    private final boolean keepSelectionWhenBeyondOuterSelectionRadius;
    private final float innerRadius;
    private final float outerRadius;
    private final float iconSize;
    private final float iconScaleFactor;
    private final int iconTextSpacer;
    private final class_327 fontRenderer;
    private final float centerX;
    private final float centerY;

    public RadialSelectionWidget(class_437 screen, int width, int height, class_2561 message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, class_327 fontRenderer) {
        this((int)((float)screen.field_22789 / 2.0f - (float)width / 2.0f), (int)((float)screen.field_22790 / 2.0f - (float)height / 2.0f), width, height, message, currentlySelectedModeSupplier, currentlyHoveredModeCallback, currentlyClickedModeCallback, modes, sectionArcAngle, sectionStartAngle, hideInactiveIcons, innerSelectionRadius, outerSelectionRadius, keepSelectionWhenBeyondOuterSelectionRadius, innerRadius, outerRadius, iconSize, iconScaleFactor, iconTextSpacer, fontRenderer);
    }

    public RadialSelectionWidget(int x, int y, int width, int height, class_2561 message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<? extends IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, class_327 fontRenderer) {
        super(x, y, width, height, message);
        this.currentlySelectedModeSupplier = currentlySelectedModeSupplier;
        this.currentlyHoveredModeCallback = currentlyHoveredModeCallback;
        this.currentlyClickedModeCallback = currentlyClickedModeCallback;
        this.keepSelectionWhenBeyondOuterSelectionRadius = keepSelectionWhenBeyondOuterSelectionRadius;
        this.modes = modes.stream().filter(mode -> !hideInactiveIcons || mode.isActive()).collect(Collectors.toList());
        this.sectionArcAngle = sectionArcAngle;
        this.sectionStartAngle = sectionStartAngle;
        this.innerSelectionRadius = innerSelectionRadius;
        this.outerSelectionRadius = outerSelectionRadius;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.iconSize = iconSize;
        this.iconScaleFactor = iconScaleFactor;
        this.iconTextSpacer = iconTextSpacer;
        this.fontRenderer = fontRenderer;
        this.centerX = (float)x + (float)width / 2.0f;
        this.centerY = (float)y + (float)height / 2.0f;
    }

    public <G extends IToolModeGroup> RadialSelectionWidget(AbstractChiselsAndBitsWidget widget, int width, int height, class_2561 message, Supplier<IRenderableMode> currentlySelectedModeSupplier, Consumer<IRenderableMode> currentlyHoveredModeCallback, Consumer<IRenderableMode> currentlyClickedModeCallback, List<? extends IRenderableMode> modes, float sectionArcAngle, float sectionStartAngle, boolean hideInactiveIcons, float innerSelectionRadius, float outerSelectionRadius, boolean keepSelectionWhenBeyondOuterSelectionRadius, float innerRadius, float outerRadius, float iconSize, float iconScaleFactor, int iconTextSpacer, class_327 fontRenderer) {
        this((int)((float)widget.method_46426() + (float)widget.method_25368() / 2.0f - (float)width / 2.0f), (int)((float)widget.method_46427() + (float)widget.method_25364() / 2.0f - (float)height / 2.0f), width, height, message, currentlySelectedModeSupplier, currentlyHoveredModeCallback, currentlyClickedModeCallback, modes, sectionArcAngle, sectionStartAngle, hideInactiveIcons, innerSelectionRadius, outerSelectionRadius, keepSelectionWhenBeyondOuterSelectionRadius, innerRadius, outerRadius, iconSize, iconScaleFactor, iconTextSpacer, fontRenderer);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int hoveredItemIndex;
        IRenderableMode current = this.currentlySelectedModeSupplier.get();
        int selectableItemCount = this.modes.size();
        if (selectableItemCount == 0) {
            return;
        }
        float centerX = (float)this.method_46426() + (float)this.field_22758 / 2.0f;
        float centerY = (float)this.method_46427() + (float)this.field_22759 / 2.0f;
        graphics.method_51448().method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.method_51448().method_46416(centerX, centerY, 0.0f);
        float itemArcAngle = this.sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialSelectionWidget.calculateMouseAngle(mouseX, mouseY, centerX, centerY);
        float mouseRadius = RadialSelectionWidget.calculateMouseRadius(mouseX, mouseY, centerX, centerY);
        float inSectionMouseAngle = mouseAngle - this.sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= this.sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius && mouseRadius <= this.outerSelectionRadius;
        int n = hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        if (!isMouseInSection && current != null && this.modes.contains(current) && this.keepSelectionWhenBeyondOuterSelectionRadius && mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius) {
            isMouseInSection = true;
            hoveredItemIndex = this.modes.indexOf(current);
        }
        RenderSystem.enableBlend();
        int renderableHoveredItemIndex = hoveredItemIndex;
        this.modes.forEach(mode -> {
            int modeIndex = this.modes.indexOf(mode);
            boolean isSelected = current != null && mode == current;
            boolean isHovered = renderableHoveredItemIndex == modeIndex;
            float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + this.sectionStartAngle;
            if (mode.isActive()) {
                RadialSelectionWidget.drawSelectableSection(graphics, this.sectionArcAngle, this.innerRadius, this.outerRadius, selectableItemCount, itemTargetAngle, isSelected, isHovered);
            } else {
                RadialSelectionWidget.drawDeactivatedSection(graphics, this.sectionArcAngle, this.innerRadius, this.outerRadius, selectableItemCount, itemTargetAngle);
            }
        });
        RenderSystem.disableBlend();
        if (isMouseInSection && hoveredItemIndex >= 0 && hoveredItemIndex < this.modes.size() && this.modes.get(hoveredItemIndex).isActive()) {
            if (IClientConfiguration.getInstance().getEnableMouseIndicatorInRadialMenu().get().booleanValue()) {
                float startOfMouseArcAngle = mouseAngle - itemArcAngle / 2.0f;
                float mouseArcAngle = itemArcAngle;
                if (this.sectionArcAngle != 360.0f) {
                    if (startOfMouseArcAngle < this.sectionStartAngle) {
                        mouseArcAngle -= this.sectionStartAngle - startOfMouseArcAngle;
                        startOfMouseArcAngle = this.sectionStartAngle;
                    }
                    if (startOfMouseArcAngle + mouseArcAngle > this.sectionStartAngle + this.sectionArcAngle) {
                        mouseArcAngle = this.sectionStartAngle + this.sectionArcAngle - startOfMouseArcAngle;
                    }
                }
                RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
                RadialSelectionWidget.drawTorus(graphics, startOfMouseArcAngle - 90.0f, mouseArcAngle, this.innerRadius, this.outerRadius);
            }
            if (hoveredItemIndex >= 0 && this.modes.get(hoveredItemIndex) != current) {
                this.currentlyHoveredModeCallback.accept(this.modes.get(hoveredItemIndex));
            }
        } else if (current != null) {
            this.currentlyHoveredModeCallback.accept(null);
        }
        this.modes.forEach(mode -> {
            if (mode.isActive()) {
                int modeIndex = this.modes.indexOf(mode);
                float itemTargetAngle = ((float)modeIndex + 0.5f) * itemArcAngle + this.sectionStartAngle;
                this.renderModeIcon(graphics, this.innerRadius, this.outerRadius, itemTargetAngle, this.iconScaleFactor, this.iconTextSpacer, (IRenderableMode)mode, this.fontRenderer);
            }
        });
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_51448().method_22909();
    }

    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTickTime) {
    }

    private static float calculateMouseAngle(float mouseX, float mouseY, float centerX, float centerY) {
        float mouseAngle;
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        for (mouseAngle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff)) - 270.0f; mouseAngle < 0.0f; mouseAngle += 360.0f) {
        }
        return mouseAngle;
    }

    private static float calculateMouseRadius(float mouseX, float mouseY, float centerX, float centerY) {
        float xDiff = mouseX - centerX;
        float yDiff = mouseY - centerY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    private static void drawSelectableSection(@NotNull class_332 graphics, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle, boolean isSelected, boolean isHovered) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
        RadialSelectionWidget.drawTorus(graphics, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        if (isSelected) {
            RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            RadialSelectionWidget.drawTorus(graphics, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
        if (isHovered) {
            RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
            RadialSelectionWidget.drawTorus(graphics, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
        }
    }

    private static void drawDeactivatedSection(@NotNull class_332 graphics, float sectionArcAngle, float innerRadius, float outerRadius, int itemCountInSection, float itemTargetAngle) {
        float itemArcAngle = sectionArcAngle / (float)itemCountInSection;
        float itemRenderAngle = itemTargetAngle - 90.0f;
        float sectionStartAngle = itemRenderAngle - itemArcAngle / 2.0f;
        RenderSystem.setShaderColor((float)0.1f, (float)0.1f, (float)0.1f, (float)0.1f);
        RadialSelectionWidget.drawTorus(graphics, sectionStartAngle, itemArcAngle, innerRadius, outerRadius);
    }

    private static void drawTorus(class_332 graphics, float startAngle, float sizeAngle, float inner, float outer) {
        RenderSystem.setShader(class_757::method_34540);
        class_287 vertexBuffer = class_289.method_1348().method_1349();
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        vertexBuffer.method_1328(class_293.class_5596.field_27380, class_290.field_1592);
        float draws = 720.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float angle = (float)Math.toRadians(startAngle + (float)i / 720.0f * 360.0f);
            vertexBuffer.method_22918(matrix4f, (float)((double)outer * Math.cos(angle)), (float)((double)outer * Math.sin(angle)), 0.0f).method_1344();
            vertexBuffer.method_22918(matrix4f, (float)((double)inner * Math.cos(angle)), (float)((double)inner * Math.sin(angle)), 0.0f).method_1344();
            ++i;
        }
        class_287.class_7433 buffer = vertexBuffer.method_1326();
        class_286.method_43433((class_287.class_7433)buffer);
    }

    private void renderModeIcon(@NotNull class_332 graphics, float innerRadius, float outerRadius, float itemTargetAngle, float iconScaleFactor, int iconTextSpacer, @NotNull IRenderableMode mode, class_327 fontRenderer) {
        int n;
        float workingAngle;
        for (workingAngle = itemTargetAngle - 90.0f; workingAngle < 0.0f; workingAngle += 360.0f) {
        }
        float itemCenterX = (float)Math.cos(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        float itemCenterY = (float)Math.sin(Math.toRadians(workingAngle)) * (innerRadius + outerRadius) / 2.0f;
        class_2561 name = mode.getMultiLineDisplayName();
        List lines = fontRenderer.method_1728((class_5348)name, 75);
        if (mode.shouldRenderDisplayNameInMenu()) {
            float f = this.iconSize * iconScaleFactor + (float)iconTextSpacer;
            Objects.requireNonNull(fontRenderer);
            n = (int)(f + (float)(9 * lines.size()));
        } else {
            n = (int)(this.iconSize * iconScaleFactor);
        }
        int itemHeight = n;
        float iconStartX = itemCenterX - this.iconSize * iconScaleFactor / 2.0f;
        float iconStartY = itemCenterY - (float)itemHeight / 2.0f;
        graphics.method_51448().method_22903();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)((float)mode.getColorVector().method_10216()), (float)((float)mode.getColorVector().method_10214()), (float)((float)mode.getColorVector().method_10215()), (float)((float)mode.getAlphaChannel()));
        RenderSystem.setShaderTexture((int)0, (class_2960)mode.getIcon());
        graphics.method_25293(mode.getIcon(), (int)iconStartX, (int)iconStartY, (int)(this.iconSize * iconScaleFactor), (int)(this.iconSize * iconScaleFactor), 0.0f, 0.0f, 18, 18, 18, 18);
        graphics.method_51448().method_22903();
        if (mode.shouldRenderDisplayNameInMenu()) {
            graphics.method_51448().method_46416(itemCenterX, itemCenterY, 0.0f);
            graphics.method_51448().method_22905(0.6f * iconScaleFactor, 0.6f * iconScaleFactor, 0.6f * iconScaleFactor);
            int offset = 0;
            for (class_5481 line : lines) {
                graphics.method_35720(fontRenderer, line, (int)((float)fontRenderer.method_30880(line) / -2.0f), iconTextSpacer + offset, -855638017);
                Objects.requireNonNull(fontRenderer);
                offset += 9;
            }
        }
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22909();
    }

    protected boolean method_25351(int usedButton) {
        return usedButton == 0;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        int hoveredItemIndex;
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        int selectableItemCount = this.modes.size();
        if (selectableItemCount == 0) {
            return false;
        }
        float itemArcAngle = this.sectionArcAngle / (float)selectableItemCount;
        float mouseAngle = RadialSelectionWidget.calculateMouseAngle((float)mouseX, (float)mouseY, this.centerX, this.centerY);
        float mouseRadius = RadialSelectionWidget.calculateMouseRadius((float)mouseX, (float)mouseY, this.centerX, this.centerY);
        float inSectionMouseAngle = mouseAngle - this.sectionStartAngle;
        boolean mouseIsInSectionArc = inSectionMouseAngle >= 0.0f && inSectionMouseAngle <= this.sectionArcAngle;
        boolean isMouseInSection = mouseIsInSectionArc && mouseRadius >= this.innerSelectionRadius && mouseRadius <= this.outerSelectionRadius;
        int n = hoveredItemIndex = !isMouseInSection ? -1 : (int)(inSectionMouseAngle / itemArcAngle);
        if (hoveredItemIndex == -1) {
            return false;
        }
        this.currentlyClickedModeCallback.accept(this.modes.get(hoveredItemIndex));
        return true;
    }
}

