/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.draw;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.VoxelShapeUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DrawnLineChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;

    DrawnLineChiselMode(class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public boolean isSingleClickUse() {
        return false;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> class_243.method_24954((class_2382)direction.method_10153().method_10163()).method_18806(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
        this.onLeftClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                mutator.inWorldMutableStream().filter(filter).forEach(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
        });
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> class_243.method_24954((class_2382)direction.method_10163()).method_18806(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
        this.onRightClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            class_2338 heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0 && (heightPos = mutator.getInWorldEndBlockPoint()).method_10264() >= context.getWorld().method_31600()) {
                class_5250 component = class_2561.method_43469((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().method_31600() - 1}).method_27692(class_124.field_1061);
                playerEntity.method_43496((class_2561)component);
            }
        });
    }

    private ClickProcessingState processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, Function<class_2350, class_243> offsetGenerator) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return ClickProcessingState.DEFAULT;
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 currentTarget = blockRayTraceResult.method_17784().method_1019(offsetGenerator.apply(blockRayTraceResult.method_17780()));
        Optional<class_243> anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        if (anchor.isEmpty()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), currentTarget);
            anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        }
        context.resetMutator();
        context.include(anchor.orElseThrow());
        context.include(currentTarget);
        Optional<class_243> finalAnchor = anchor;
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                IWorldAreaAccessor worldAreaAccessor = (IWorldAreaAccessor)areaAccessor;
                return new LineAreaFilter((class_243)finalAnchor.get(), currentTarget);
            }
            return s -> false;
        });
        return ClickProcessingState.ALLOW;
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(IAreaAccessor.class::cast);
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        IWorldAreaMutator mutator = context.getMutator().get();
        Optional<Predicate> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator));
        if (filter.isEmpty()) {
            return class_259.method_1073();
        }
        Predicate stateFilter = filter.get();
        if (!(stateFilter instanceof LineAreaFilter)) {
            return class_259.method_1073();
        }
        LineAreaFilter lineAreaFilter = (LineAreaFilter)stateFilter;
        class_2338 offset = VectorUtils.invert(mutator.getInWorldEndBlockPoint());
        List<class_243> startPoints = lineAreaFilter.included.stream().map(v -> v.method_18806(StateEntrySize.current().getSizePerBitScalingVector())).toList();
        return VoxelShapeUtils.batchCombine(class_259.method_1073(), class_247.field_1366, true, startPoints.stream().map(p -> class_259.method_1081((double)p.field_1352, (double)p.field_1351, (double)p.field_1350, (double)(p.field_1352 + (double)StateEntrySize.current().getSizePerBit()), (double)(p.field_1351 + (double)StateEntrySize.current().getSizePerBit()), (double)(p.field_1350 + (double)StateEntrySize.current().getSizePerBit()))).collect(Collectors.toList())).method_1096((double)offset.method_10263(), (double)offset.method_10264(), (double)offset.method_10260());
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.DRAW);
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class LineAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final class_243 origin;
        private final class_243 magnitude;
        private final List<class_243> included;

        private LineAreaFilter(class_243 startPoint, class_243 endPoint) {
            this.origin = startPoint.method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            this.magnitude = endPoint.method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector()).method_1020(this.origin);
            this.included = this.calculateIncludedPositions();
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            return this.included.contains(inWorldStateEntryInfo.getInWorldStartPoint().method_18806(StateEntrySize.current().getBitsPerBlockSideScalingVector()));
        }

        private List<class_243> calculateIncludedPositions() {
            double zDist;
            ArrayList<class_2382> positions = new ArrayList<class_2382>();
            class_243 direction = this.magnitude.method_1029();
            double xLen = direction.method_1021(1.0 / direction.method_10216()).method_1033();
            double yLen = direction.method_1021(1.0 / direction.method_10214()).method_1033();
            double zLen = direction.method_1021(1.0 / direction.method_10215()).method_1033();
            double reach = this.magnitude.method_1033();
            double distanceFromStart = 0.0;
            class_2382 pos = new class_2382((int)(direction.method_10216() > 0.0 ? Math.ceil(this.origin.method_10216()) - 1.0 : Math.floor(this.origin.method_10216())), (int)(direction.method_10214() > 0.0 ? Math.ceil(this.origin.method_10214()) - 1.0 : Math.floor(this.origin.method_10214())), (int)(direction.method_10215() > 0.0 ? Math.ceil(this.origin.method_10215()) - 1.0 : Math.floor(this.origin.method_10215())));
            double xOff = direction.method_10216() > 0.0 ? (double)(1 + pos.method_10263()) - this.origin.method_10216() : this.origin.method_10216() - (double)pos.method_10263();
            double yOff = direction.method_10214() > 0.0 ? (double)(1 + pos.method_10264()) - this.origin.method_10214() : this.origin.method_10214() - (double)pos.method_10264();
            double zOff = direction.method_10215() > 0.0 ? (double)(1 + pos.method_10260()) - this.origin.method_10215() : this.origin.method_10215() - (double)pos.method_10260();
            double xDist = Double.isNaN(xLen) ? Double.POSITIVE_INFINITY : Math.abs(xOff * xLen);
            double yDist = Double.isNaN(yLen) ? Double.POSITIVE_INFINITY : Math.abs(yOff * yLen);
            double d = zDist = Double.isNaN(zLen) ? Double.POSITIVE_INFINITY : Math.abs(zOff * zLen);
            while (distanceFromStart <= reach) {
                positions.add(pos);
                if (xDist < yDist) {
                    if (xDist < zDist) {
                        distanceFromStart = xDist;
                        xDist += xLen;
                        pos = pos.method_34592(direction.method_10216() > 0.0 ? 1 : -1, 0, 0);
                        continue;
                    }
                    distanceFromStart = zDist;
                    zDist += zLen;
                    pos = pos.method_34592(0, 0, direction.method_10215() > 0.0 ? 1 : -1);
                    continue;
                }
                if (yDist < zDist) {
                    distanceFromStart = yDist;
                    yDist += yLen;
                    pos = pos.method_34592(0, direction.method_10214() > 0.0 ? 1 : -1, 0);
                    continue;
                }
                distanceFromStart = zDist;
                zDist += zLen;
                pos = pos.method_34592(0, 0, direction.method_10215() > 0.0 ? 1 : -1);
            }
            return positions.stream().map(i -> new class_243((double)i.method_10263(), (double)i.method_10264(), (double)i.method_10260())).collect(Collectors.toList());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LineAreaFilter)) {
                return false;
            }
            LineAreaFilter that = (LineAreaFilter)o;
            if (!this.origin.equals((Object)that.origin)) {
                return false;
            }
            if (!this.magnitude.equals((Object)that.magnitude)) {
                return false;
            }
            return this.included.equals(that.included);
        }

        public int hashCode() {
            int result = this.origin.hashCode();
            result = 31 * result + this.magnitude.hashCode();
            result = 31 * result + this.included.hashCode();
            return result;
        }
    }
}

