/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.cubed;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class CubedChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int bitsPerSide;
    private final boolean aligned;
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;

    CubedChiselMode(int bitsPerSide, boolean aligned, class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.bitsPerSide = bitsPerSide;
        this.aligned = aligned;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10153().method_10163()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        context.setComplete();
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                int totalItemDamage = mutator.inWorldMutableStream().mapToInt(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10163()), facingVector -> this.aligned ? facingVector : facingVector.method_18805(1.0, -1.0, 1.0));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            class_2338 heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir()).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir()).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0 && (heightPos = mutator.getInWorldEndBlockPoint()).method_10264() >= context.getWorld().method_31600()) {
                class_5250 component = class_2561.method_43469((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().method_31600() - 1}).method_27692(class_124.field_1061);
                playerEntity.method_43496((class_2561)component);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return class_259.method_1073();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, Function<class_2350, class_243> placementFacingAdapter, Function<class_243, class_243> fullFacingVectorAdapter) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_243 alignmentOffset = class_243.field_1353;
        class_243 fullFacingVector = fullFacingVectorAdapter.apply(this.aligned ? new class_243(1.0, 1.0, 1.0) : class_243.method_24954((class_2382)RayTracingUtils.getFullFacingVector(playerEntity)));
        if (this.aligned) {
            class_243 inBlockOffset = hitVector.method_1020(class_243.method_24954((class_2382)VectorUtils.toInteger(hitVector)));
            class_2338 bitsInBlockOffset = VectorUtils.toBlockPos(inBlockOffset.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
            class_2338 targetedSectionIndices = new class_2338(bitsInBlockOffset.method_10263() / this.bitsPerSide, bitsInBlockOffset.method_10264() / this.bitsPerSide, bitsInBlockOffset.method_10260() / this.bitsPerSide);
            class_2338 targetedStartPoint = new class_2338(targetedSectionIndices.method_10263() * this.bitsPerSide, targetedSectionIndices.method_10264() * this.bitsPerSide, targetedSectionIndices.method_10260() * this.bitsPerSide);
            class_2338 targetedBitsInBlockOffset = bitsInBlockOffset.method_10059((class_2382)targetedStartPoint);
            alignmentOffset = class_243.method_24954((class_2382)targetedBitsInBlockOffset).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        }
        class_243 finalAlignmentOffset = alignmentOffset.method_18806(fullFacingVector);
        BlockPosStreamProvider.getForRange(this.bitsPerSide).forEach(bitPos -> context.include(hitVector.method_1020(finalAlignmentOffset).method_1019(class_243.method_24954((class_2382)bitPos).method_18806(fullFacingVector).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()))));
        return Optional.empty();
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(this.aligned ? ModChiselModeGroups.CUBED_ALIGNED : ModChiselModeGroups.CUBED);
    }
}

