/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Optional;
import java.util.UUID;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.chiseling.ChiselingContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2960;

public class ChiselingManager
implements IChiselingManager {
    private static final ChiselingManager INSTANCE = new ChiselingManager();
    private UUID activeInstanceId = UUID.randomUUID();
    private final ThreadLocal<UUID> activeThreadId = ThreadLocal.withInitial(() -> this.activeInstanceId);
    private final ThreadLocal<Table<UUID, class_2960, IChiselingContext>> contexts = ThreadLocal.withInitial(HashBasedTable::create);
    private final ThreadLocal<Table<UUID, class_2960, Long>> lastUsedChiselMoments = ThreadLocal.withInitial(HashBasedTable::create);

    private ChiselingManager() {
    }

    public static ChiselingManager getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<IChiselingContext> get(class_1657 playerEntity, IChiselMode mode) {
        UUID playerId = playerEntity.method_5667();
        class_2960 worldId = playerEntity.method_5770().method_27983().method_29177();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored == null) {
            return Optional.empty();
        }
        return Optional.of(currentStored);
    }

    @Override
    public Optional<IChiselingContext> get(class_1657 playerEntity, IChiselMode mode, ChiselingOperation modeOfOperandus) {
        UUID playerId = playerEntity.method_5667();
        class_2960 worldId = playerEntity.method_5770().method_27983().method_29177();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored == null) {
            return Optional.empty();
        }
        if (currentStored.getModeOfOperandus() == modeOfOperandus) {
            return Optional.of(currentStored);
        }
        return Optional.empty();
    }

    @Override
    public IChiselingContext create(class_1657 playerEntity, IChiselMode mode, ChiselingOperation modeOfOperandus, boolean simulation, class_1799 causingItemStack) {
        UUID playerId = playerEntity.method_5667();
        class_2960 worldId = playerEntity.method_5770().method_27983().method_29177();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored != null && !simulation) {
            this.contexts.get().remove((Object)playerId, (Object)worldId);
        }
        ChiselingContext newContext = new ChiselingContext((class_1936)playerEntity.method_5770(), mode, modeOfOperandus, simulation, () -> {
            if (simulation) {
                return;
            }
            this.lastUsedChiselMoments.get().put((Object)playerId, (Object)worldId, (Object)playerEntity.field_6012);
            this.contexts.get().remove((Object)playerId, (Object)worldId);
        }, causingItemStack, playerEntity);
        if (!simulation) {
            this.contexts.get().put((Object)playerId, (Object)worldId, (Object)newContext);
        }
        return newContext;
    }

    public boolean canChisel(class_1657 playerEntity) {
        this.validateOrSetup();
        UUID playerId = playerEntity.method_5667();
        class_2960 worldId = playerEntity.method_5770().method_27983().method_29177();
        Long lastChiselTime = (Long)this.lastUsedChiselMoments.get().get((Object)playerId, (Object)worldId);
        if (lastChiselTime == null) {
            return true;
        }
        long time = playerEntity.field_6012;
        long diffSinceLastUse = time - lastChiselTime;
        if (diffSinceLastUse < 0L || diffSinceLastUse > 3L) {
            this.resetLastChiselCountdown(playerEntity);
            return true;
        }
        return false;
    }

    public void onServerStarting() {
        this.activeInstanceId = UUID.randomUUID();
    }

    private void validateOrSetup() {
        UUID threadId = this.activeThreadId.get();
        if (threadId != this.activeInstanceId) {
            this.contexts.get().clear();
            this.lastUsedChiselMoments.get().clear();
            this.activeThreadId.set(this.activeInstanceId);
        }
    }

    public void resetLastChiselCountdown(class_1657 player) {
        this.lastUsedChiselMoments.get().row((Object)player.method_5667()).clear();
    }
}

