/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_437;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ScreenExtension;
import top.mcmtr.mod.blocks.BlockCatenaryNode;
import top.mcmtr.mod.blocks.BlockCatenaryWithModel;
import top.mcmtr.mod.blocks.BlockCustomTextBase;
import top.mcmtr.mod.blocks.BlockYamanoteRailwaySign;
import top.mcmtr.mod.screen.CatenaryScreen;
import top.mcmtr.mod.screen.CatenaryWithModelScreen;
import top.mcmtr.mod.screen.CustomTextScreen;
import top.mcmtr.mod.screen.RigidCatenaryShapeModifierScreen;
import top.mcmtr.mod.screen.YamanoteRailwaySignScreen;

public final class MSDClientPacketHelper {
    public static void openMSDBlockEntityScreen(BlockPos blockPos) {
        MSDClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity) {
                MSDClientPacketHelper.openScreen(new YamanoteRailwaySignScreen(blockPos), screenExtension -> screenExtension instanceof YamanoteRailwaySignScreen);
            }
        });
    }

    public static void openCatenaryScreen(boolean isConnected, BlockPos blockPos) {
        MSDClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockCatenaryNode.BlockCatenaryNodeEntity) {
                MSDClientPacketHelper.openScreen(new CatenaryScreen(isConnected, blockPos), screenExtension -> screenExtension instanceof CatenaryScreen);
            }
        });
    }

    public static void openCustomTextScreen(BlockPos blockPos, int maxArrivals) {
        MSDClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockCustomTextBase.BlockCustomTextEntity) {
                MSDClientPacketHelper.openScreen(new CustomTextScreen(blockPos, maxArrivals), screenExtension -> screenExtension instanceof CustomTextScreen);
            }
        });
    }

    public static void openRigidCatenaryShapeModifierScreen(String rigidCatenaryId) {
        MSDClientPacketHelper.openScreen(new RigidCatenaryShapeModifierScreen(rigidCatenaryId), screenExtension -> screenExtension instanceof RigidCatenaryShapeModifierScreen);
    }

    public static void openCatenaryWithModelScreen(BlockPos blockPos, boolean isConnected) {
        MSDClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockCatenaryWithModel.BlockCatenaryWithModelEntity) {
                MSDClientPacketHelper.openScreen(new CatenaryWithModelScreen(blockPos, isConnected), screenExtension -> screenExtension instanceof CatenaryWithModelScreen);
            }
        });
    }

    private static void openScreen(ScreenExtension screenExtension, Predicate<ScreenExtension> isInstance) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        Screen screen = minecraftClient.getCurrentScreenMapped();
        if (screen == null || screen.data instanceof ScreenExtension && !isInstance.test((ScreenExtension)screen.data)) {
            minecraftClient.openScreen(new Screen((class_437)screenExtension));
        }
    }

    private static void getBlockEntity(BlockPos blockPos, Consumer<BlockEntity> consumer) {
        BlockEntity blockEntity;
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null && (blockEntity = clientWorld.getBlockEntity(blockPos)) != null) {
            consumer.accept(blockEntity);
        }
    }
}

