/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.data;

import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import top.mcmtr.core.data.CatenaryType;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.core.data.VectorLocation;
import top.mcmtr.mod.config.Config;

public final class CatenaryMath {
    private final double xStart;
    private final double yStart;
    private final double zStart;
    private final double xEnd;
    private final double yEnd;
    private final double zEnd;
    private final double count;
    private final double increment;
    private final double increment2;
    private final double sinX;
    private final double sinZ;
    private final CatenaryType catenaryType;
    private final ObjectArrayList<VectorLocation> corner = new ObjectArrayList();
    private boolean checkRun = false;
    public static final double CATENARY_WIDTH = 0.015625;
    private static final int MAX_ELECTRIC_DIP = 8;

    public CatenaryMath(Position positionStart, Position positionEnd, OffsetPosition offsetStart, OffsetPosition offsetEnd, CatenaryType catenaryType) {
        this.xStart = (double)positionStart.getX() + offsetStart.getX();
        this.yStart = (double)positionStart.getY() + offsetStart.getY();
        this.zStart = (double)positionStart.getZ() + offsetStart.getZ();
        this.xEnd = (double)positionEnd.getX() + offsetEnd.getX();
        this.yEnd = (double)positionEnd.getY() + offsetEnd.getY();
        this.zEnd = (double)positionEnd.getZ() + offsetEnd.getZ();
        this.catenaryType = catenaryType;
        this.count = this.getLength();
        this.increment = this.count / (double)Math.round(this.count / 2.0);
        this.increment2 = this.increment - 0.5;
        this.sinX = this.getSin(this.zStart, this.zEnd, this.count);
        this.sinZ = this.getSin(this.xStart, this.xEnd, this.count);
    }

    public void init() {
        if (!this.checkRun) {
            for (double i = 0.0; i < this.count - 0.1; i += this.increment) {
                VectorLocation cornerTemp = new VectorLocation(this.getPositionXZ(i, this.xStart, this.xEnd) + 0.5, this.getPositionY(i, this.yStart, this.yEnd), this.getPositionXZ(i, this.zStart, this.zEnd) + 0.5, this.getPositionXZ(i + this.increment, this.xStart, this.xEnd) + 0.5, this.getPositionY(i + this.increment, this.yStart, this.yEnd), this.getPositionXZ(i + this.increment, this.zStart, this.zEnd) + 0.5, i);
                this.corner.add((Object)cornerTemp);
            }
            this.checkRun = !this.checkRun;
        }
    }

    public void render(RenderCatenary callback) {
        this.init();
        double base = 0.6;
        if (this.count < 8.0) {
            for (VectorLocation cornerResult : this.corner) {
                callback.renderCatenary(cornerResult.x1, cornerResult.y1, cornerResult.z1, cornerResult.x2, cornerResult.y2, cornerResult.z2, this.count, cornerResult.i, base, this.sinX, this.sinZ, this.increment2);
            }
        } else {
            for (VectorLocation cornerResult : this.corner) {
                callback.renderCatenary(cornerResult.x1, cornerResult.y1, cornerResult.z1, cornerResult.x2, cornerResult.y2, cornerResult.z2, this.count, cornerResult.i, base, this.sinX, this.sinZ, this.increment2);
                if (cornerResult.i < this.count / 2.0 - this.increment2) {
                    base *= 0.5;
                    continue;
                }
                if (!(cornerResult.i >= this.count / 2.0)) continue;
                base /= 0.5;
            }
        }
    }

    private double getPositionXZ(double value, double start, double end) {
        double offsetValue;
        double initial;
        double change;
        double intercept = this.count / 2.0;
        if (value < intercept) {
            change = (end - start) / 2.0;
            initial = start;
            offsetValue = value;
        } else {
            change = (start - end) / 2.0;
            initial = end;
            offsetValue = this.count - value;
        }
        return change / intercept * offsetValue + initial;
    }

    private double getPositionY(double value, double start, double end) {
        int ELECTRIC_CURVATURE_SCALE = Config.getElectricCurvatureScale();
        if (this.catenaryType == CatenaryType.ELECTRIC) {
            if (value < 0.5) {
                return start;
            }
            if (value > this.count - 0.5) {
                return end;
            }
            double offsetValue = value - 0.5;
            double offsetLength = this.count - 1.0;
            double posY = start + (end - start) * offsetValue / offsetLength;
            double dip = offsetLength * offsetLength / 4.0 / (double)ELECTRIC_CURVATURE_SCALE;
            return posY + (dip > 8.0 ? 8.0 / dip : 1.0) * (offsetValue - offsetLength) * offsetValue / (double)ELECTRIC_CURVATURE_SCALE;
        }
        return this.getPositionXZ(value, start, end);
    }

    private double getLength() {
        return Math.sqrt((this.xEnd - this.xStart) * (this.xEnd - this.xStart) + (this.yEnd - this.yStart) * (this.yEnd - this.yStart) + (this.zEnd - this.zStart) * (this.zEnd - this.zStart));
    }

    public boolean verify() {
        return this.count > 0.0;
    }

    private double getSin(double start, double end, double length) {
        return (end - start) / length * 0.015625;
    }

    @FunctionalInterface
    public static interface RenderCatenary {
        public void renderCatenary(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);
    }
}

