/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.generator.BlockStateGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.api.blocks.BlockSpecification;
import com.supermartijn642.rechiseled.blocks.RechiseledPillarBlock;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import net.minecraft.class_2248;
import net.minecraft.class_2350;

public class RegistrationBlockStateGenerator
extends BlockStateGenerator {
    private final RechiseledRegistrationImpl registration;

    public RegistrationBlockStateGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().stream().map(Pair::right).forEach(type -> {
            if (type.hasRegularVariant()) {
                this.createBlockState(type.getSpecification(), type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.createBlockState(type.getSpecification(), type.getConnectingBlock());
            }
        });
    }

    private void createBlockState(BlockSpecification specification, class_2248 block) {
        String namespace = Registries.BLOCKS.getIdentifier((Object)block).method_12836();
        String identifier = Registries.BLOCKS.getIdentifier((Object)block).method_12832();
        if (specification == BlockSpecification.BASIC || specification == BlockSpecification.GLASS) {
            this.blockState(block).emptyVariant(variant -> variant.model(namespace, "block/" + identifier));
        } else if (specification == BlockSpecification.PILLAR || specification == BlockSpecification.GLASS_PILLAR) {
            this.blockState(block).variantsForProperty(RechiseledPillarBlock.AXIS_PROPERTY, (state, variant) -> {
                class_2350.class_2351 axis = (class_2350.class_2351)state.get(RechiseledPillarBlock.AXIS_PROPERTY);
                if (axis == class_2350.class_2351.field_11048) {
                    variant.model(namespace, "block/" + identifier, 90, 90);
                } else if (axis == class_2350.class_2351.field_11051) {
                    variant.model(namespace, "block/" + identifier, 90, 0);
                } else {
                    variant.model(namespace, "block/" + identifier);
                }
            });
        }
    }

    public String getName() {
        return "Registration Block State Generator: " + this.modName;
    }
}

