/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.network.gui;

import com.lx862.jcm.mod.data.EnquiryScreenType;
import com.lx862.jcm.mod.data.TransactionEntry;
import com.lx862.jcm.mod.network.gui.ClientHelper;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class EnquiryUpdateGUIPacket
extends PacketHandler {
    private final EnquiryScreenType type;
    private final List<TransactionEntry> entries;
    private final BlockPos pos;
    private final int entryCount;
    private final int remainingBalance;

    public EnquiryUpdateGUIPacket(PacketBufferReceiver packetBufferReceiver) {
        this.entries = new ArrayList<TransactionEntry>();
        this.type = EnquiryScreenType.valueOf(packetBufferReceiver.readString());
        this.pos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.remainingBalance = packetBufferReceiver.readInt();
        this.entryCount = packetBufferReceiver.readInt();
        for (int i = 0; i < this.entryCount; ++i) {
            String source = packetBufferReceiver.readString();
            long amount = packetBufferReceiver.readLong();
            long time = packetBufferReceiver.readLong();
            this.entries.add(new TransactionEntry(source, amount, time));
        }
    }

    public EnquiryUpdateGUIPacket(EnquiryScreenType type, BlockPos pos, List<TransactionEntry> entries, int remainingBalance) {
        this.type = type;
        this.entries = entries;
        this.entryCount = entries.size();
        this.pos = pos;
        this.remainingBalance = remainingBalance;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.type.toString());
        packetBufferSender.writeLong(this.pos.asLong());
        packetBufferSender.writeInt(this.remainingBalance);
        packetBufferSender.writeInt(this.entries.size());
        for (TransactionEntry transactionEntry : this.entries) {
            packetBufferSender.writeString(transactionEntry.source());
            packetBufferSender.writeLong(transactionEntry.amount());
            packetBufferSender.writeLong(transactionEntry.time());
        }
    }

    public void runClient() {
        ClientHelper.openEnquiryScreen(this.type, this.pos, this.entries, this.remainingBalance);
    }
}

