/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block;

import com.lx862.jcm.mod.block.base.WallAttachedBlock;
import com.lx862.jcm.mod.block.entity.SubsidyMachineBlockEntity;
import com.lx862.jcm.mod.data.JCMServerStats;
import com.lx862.jcm.mod.network.gui.SubsidyMachineGUIPacket;
import com.lx862.jcm.mod.registry.Networking;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.UUID;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.TicketSystem;

public class SubsidyMachineBlock
extends WallAttachedBlock
implements BlockWithEntity {
    private static final Object2LongOpenHashMap<UUID> cooldownMap = new Object2LongOpenHashMap();

    public SubsidyMachineBlock(BlockSettings settings) {
        super(settings);
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)4.0, (double)1.25, (double)0.0, (double)12.0, (double)14.75, (double)2.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be == null) {
            return ActionResult.FAIL;
        }
        SubsidyMachineBlockEntity sbe = (SubsidyMachineBlockEntity)((Object)be.data);
        return IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> Networking.sendPacketToClient(player, new SubsidyMachineGUIPacket(pos, sbe.getSubsidyAmount(), sbe.getCooldown())), () -> {
            if (SubsidyMachineBlock.cooldownExpired(player, sbe.getCooldown())) {
                SubsidyMachineBlock.updateCooldown(player);
                int finalBalance = SubsidyMachineBlock.addMTRBalanceToPlayer(world, player, sbe.getSubsidyAmount());
                player.sendMessage(Text.cast((HolderBase)TextUtil.translatable(TextCategory.HUD, "subsidy_machine.success", sbe.getSubsidyAmount(), finalBalance)), true);
            } else {
                int remainingSec = Math.round((long)sbe.getCooldown() - SubsidyMachineBlock.getCooldown(player));
                player.sendMessage(Text.cast((HolderBase)TextUtil.translatable(TextCategory.HUD, "subsidy_machine.fail", remainingSec).formatted(TextFormatting.RED)), true);
            }
        });
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SubsidyMachineBlockEntity(blockPos, blockState);
    }

    private static int addMTRBalanceToPlayer(World world, PlayerEntity player, int amount) {
        TicketSystem.addBalance((World)world, (PlayerEntity)player, (int)amount);
        return TicketSystem.getBalance((World)world, (PlayerEntity)player);
    }

    private static boolean cooldownExpired(PlayerEntity player, int cooldown) {
        return SubsidyMachineBlock.getCooldown(player) >= (long)cooldown;
    }

    private static long getCooldown(PlayerEntity player) {
        return ((long)JCMServerStats.getGameTick() - cooldownMap.getOrDefault((Object)player.getUuid(), 0L)) / 20L;
    }

    private static void updateCooldown(PlayerEntity player) {
        cooldownMap.put((Object)player.getUuid(), (long)JCMServerStats.getGameTick());
    }
}

