/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.util.TriPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class BlockProperties {
    private Function<class_2680, class_3620> mapColor;
    private boolean hasCollision = true;
    private class_2498 soundType = class_2498.field_11544;
    private ToIntFunction<class_2680> lightLevel = state -> 0;
    private float explosionResistance;
    private float destroyTime;
    private boolean requiresCorrectTool = false;
    private boolean ticksRandomly = false;
    private float friction = 0.6f;
    private float speedFactor = 1.0f;
    private float jumpFactor = 1.0f;
    private boolean canOcclude = true;
    private boolean isAir = false;
    private boolean ignitedByLava = false;
    private class_3619 pushReaction = class_3619.field_15974;
    private class_2766 instrument = class_2766.field_12648;
    boolean replaceable = false;
    private TriPredicate<class_2680, class_1922, class_2338> isRedstoneConductor = class_4970.class_4971::method_26234;
    private TriPredicate<class_2680, class_1922, class_2338> isSuffocating = (state, level, pos) -> state.method_51366() && state.method_26234(level, pos);
    private boolean hasDynamicShape = false;
    boolean noLootTable = false;
    Supplier<class_2248> lootTableBlock;
    class_2960 lootTable;

    public static BlockProperties create() {
        return new BlockProperties();
    }

    public static BlockProperties fromVanilla(class_4970.class_2251 vanilla) {
        BlockProperties properties = BlockProperties.create();
        properties.mapColor = vanilla.field_10662;
        properties.hasCollision = vanilla.field_10664;
        properties.soundType = vanilla.field_10665;
        properties.lightLevel = vanilla.field_10663;
        properties.explosionResistance = vanilla.field_10660;
        properties.destroyTime = vanilla.field_10669;
        properties.requiresCorrectTool = vanilla.field_25185;
        properties.ticksRandomly = vanilla.field_10661;
        properties.friction = vanilla.field_10667;
        properties.speedFactor = vanilla.field_23179;
        properties.jumpFactor = vanilla.field_21209;
        properties.canOcclude = vanilla.field_20721;
        properties.isAir = vanilla.field_23180;
        properties.ignitedByLava = vanilla.field_43394;
        properties.pushReaction = vanilla.field_43395;
        properties.instrument = vanilla.field_44629;
        properties.replaceable = vanilla.field_44630;
        properties.isRedstoneConductor = (arg_0, arg_1, arg_2) -> ((class_4970.class_4973)vanilla.field_23182).test(arg_0, arg_1, arg_2);
        properties.isSuffocating = (arg_0, arg_1, arg_2) -> ((class_4970.class_4973)vanilla.field_23183).test(arg_0, arg_1, arg_2);
        properties.hasDynamicShape = vanilla.field_10670;
        properties.lootTable = vanilla.field_10666;
        return properties;
    }

    public static BlockProperties copy(class_2248 block) {
        return BlockProperties.fromVanilla(block.field_23155);
    }

    private BlockProperties() {
    }

    public BlockProperties mapColor(Function<class_2680, class_3620> colorFunction) {
        this.mapColor = colorFunction;
        return this;
    }

    public BlockProperties mapColor(class_3620 color) {
        return this.mapColor((class_2680 state) -> color);
    }

    public BlockProperties collision(boolean hasCollision) {
        this.hasCollision = hasCollision;
        if (!hasCollision) {
            this.canOcclude = false;
        }
        return this;
    }

    public BlockProperties noCollision() {
        return this.collision(false);
    }

    public BlockProperties sound(class_2498 soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<class_2680> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties strength(float strength) {
        return this.explosionResistance(strength).destroyTime(strength);
    }

    public BlockProperties requiresCorrectTool(boolean requiresCorrectTool) {
        this.requiresCorrectTool = requiresCorrectTool;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        return this.requiresCorrectTool(true);
    }

    public BlockProperties randomTicks(boolean receiveRandomTicks) {
        this.ticksRandomly = receiveRandomTicks;
        return this;
    }

    public BlockProperties randomTicks() {
        return this.randomTicks(true);
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties canOcclude(boolean canOcclude) {
        this.canOcclude = canOcclude;
        return this;
    }

    public BlockProperties noOcclusion() {
        return this.canOcclude(false);
    }

    public BlockProperties air(boolean isAir) {
        this.isAir = isAir;
        return this;
    }

    public BlockProperties air() {
        return this.air(true);
    }

    public BlockProperties ignitedByLava(boolean getsIgnitedByLava) {
        this.ignitedByLava = getsIgnitedByLava;
        return this;
    }

    public BlockProperties ignitedByLava() {
        return this.ignitedByLava(true);
    }

    public BlockProperties pushReaction(class_3619 pushReaction) {
        this.pushReaction = pushReaction;
        return this;
    }

    public BlockProperties instrument(class_2766 instrument) {
        this.instrument = instrument;
        return this;
    }

    public BlockProperties replaceable(boolean isReplaceable) {
        this.replaceable = isReplaceable;
        return this;
    }

    public BlockProperties replaceable() {
        return this.replaceable(true);
    }

    public BlockProperties isRedstoneConductor(TriPredicate<class_2680, class_1922, class_2338> isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor;
        return this;
    }

    public BlockProperties isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = (state, blockGetter, pos) -> isRedstoneConductor;
        return this;
    }

    public BlockProperties isSuffocating(TriPredicate<class_2680, class_1922, class_2338> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = (state, blockGetter, pos) -> isSuffocating;
        return this;
    }

    public BlockProperties dynamicShape() {
        this.hasDynamicShape = true;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableBlock = null;
        this.lootTable = null;
        return this;
    }

    public BlockProperties lootTable(class_2960 lootTable) {
        this.noLootTable = false;
        this.lootTableBlock = null;
        this.lootTable = lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<class_2248> block) {
        this.noLootTable = false;
        this.lootTableBlock = block;
        this.lootTable = null;
        return this;
    }

    @Deprecated
    public class_4970.class_2251 toUnderlying() {
        class_4970.class_2251 properties = class_4970.class_2251.method_9637();
        if (this.mapColor != null) {
            properties.method_51520(this.mapColor);
        }
        if (!this.hasCollision) {
            properties.method_9634();
        }
        properties.method_9626(this.soundType);
        properties.method_9631(this.lightLevel);
        properties.method_9632(this.explosionResistance);
        properties.method_36557(this.destroyTime);
        if (this.requiresCorrectTool) {
            properties.method_29292();
        }
        if (this.ticksRandomly) {
            properties.method_9640();
        }
        properties.method_9628(this.friction);
        properties.method_23351(this.speedFactor);
        properties.method_23352(this.jumpFactor);
        if (this.noLootTable) {
            properties.method_42327();
        }
        if (!this.canOcclude) {
            properties.method_22488();
        }
        if (this.isAir) {
            properties.method_26250();
        }
        if (this.ignitedByLava) {
            properties.method_50013();
        }
        properties.method_50012(this.pushReaction);
        properties.method_51368(this.instrument);
        if (this.replaceable) {
            properties.method_51371();
        }
        properties.method_26236(this.isRedstoneConductor::test);
        properties.method_26243(this.isSuffocating::test);
        properties.method_26245(this.isSuffocating::test);
        if (this.hasDynamicShape) {
            properties.method_9624();
        }
        return properties;
    }
}

