/*
 * Decompiled with CFR 0.152.
 */
package com.tianeo.realtime.realtime;

import java.time.LocalTime;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Realtime
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Realtime");
    public int SetTimeOfDayCount = 0;

    public void onInitialize() {
        ServerWorldEvents.LOAD.register(this::DisableDoDaylightCycle);
        ServerTickEvents.START_SERVER_TICK.register(this::SetTimeToRealtime);
        LOGGER.info("Successfully loaded Realtime");
    }

    public void DisableDoDaylightCycle(MinecraftServer server, class_3218 _w) {
        Iterable worlds = server.method_3738();
        worlds.forEach(world -> {
            class_1928 rules = world.method_8450();
            ((class_1928.class_4310)rules.method_20746(class_1928.field_19396)).method_20758(false, server);
        });
        this.SetTimeOfDayCount = 59;
        this.SetTimeToRealtime(server);
    }

    public void SetTimeToRealtime(MinecraftServer server) {
        if (++this.SetTimeOfDayCount % 60 == 0) {
            try {
                class_3218 world = server.method_30002().method_8410();
                if (world == null) {
                    throw new Error("Failed to get overworld pointer");
                }
                LocalTime systemTime = LocalTime.now();
                long secondsFromSixAM = systemTime.getSecond() + systemTime.getMinute() * 60 + (systemTime.getHour() - 6) * 3600;
                long ticks = (Math.round((double)(secondsFromSixAM * 24000L) / 86400.0) + 24000L) % 24000L;
                world.method_29199(ticks);
            }
            catch (Exception e) {
                LOGGER.error("Failed to set time of day", (Throwable)e);
            }
            this.SetTimeOfDayCount = 0;
        }
    }
}

