/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.registry;

import fr.addonslib.api.data.BlockId;
import fr.addonslib.api.data.McwBlockIdBase;
import fr.addonslib.api.data.McwBlocksIdBase;
import fr.addonslib.api.data.ModType;
import fr.addonslib.api.registry.ConditionalsRegistry;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.RegistryEntryReferences;
import fr.samlegamer.addonslib.registry.McwProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2498;
import net.minecraft.class_2533;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_8177;

public final class McwRegistry {
    private McwRegistry() {
    }

    public static Map<String, class_2498> makeDefaultFromList(List<String> list, class_2498 soundType) {
        LinkedHashMap<String, class_2498> map = new LinkedHashMap<String, class_2498>();
        for (String str : list) {
            map.put(str, soundType);
        }
        return map;
    }

    public static void setRegistriesWood(String MODID, List<String> list, ModType ... type) {
        McwRegistry.setRegistriesWood(MODID, McwRegistry.makeDefaultFromList(list, class_2498.field_11547), type);
    }

    public static void setRegistriesWood(String MODID, Map<String, class_2498> stringSoundTypeMap, ModType ... type) {
        FabricLoader modList = FabricLoader.getInstance();
        LinkedHashMap<String, class_2498> orderedMap = new LinkedHashMap<String, class_2498>(stringSoundTypeMap);
        for (ModType mod : type) {
            for (Map.Entry map : orderedMap.entrySet()) {
                String mat = (String)map.getKey();
                class_2498 soundType = (class_2498)map.getValue();
                class_8177 blockSetType = McwRegistry.getBlockSetType(soundType);
                class_4719 woodType = McwRegistry.getWoodType(soundType);
                McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidWood(mod);
                for (BlockId blockId : mcwBlockIdBase.blocks()) {
                    String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                    String reflectedLocation = blockId.reflectedLocation().getFabric();
                    class_4970.class_2251 prop = McwProperties.getWoodProperties(mat, mod).method_9626(soundType);
                    boolean isModLoaded = modList.isModLoaded(mcwBlockIdBase.modid());
                    if (isModLoaded) {
                        if (ConditionalsRegistry.isBlockDefaultState("1.18.2Fabric", reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, Registration.getBlocksField(blockId.reflectedLocation().getFabric(), prop, class_2246.field_10161.method_9564()));
                            continue;
                        }
                        if (ConditionalsRegistry.isBlockSetType(reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, Registration.getBlocksField(blockId.reflectedLocation().getFabric(), prop, blockSetType));
                            continue;
                        }
                        if (ConditionalsRegistry.isFence(reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2354(prop));
                            continue;
                        }
                        if (ConditionalsRegistry.isFenceGate(reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2349(prop, woodType));
                            continue;
                        }
                        if (ConditionalsRegistry.isTrapdoor(id)) {
                            RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2533(prop, blockSetType));
                            continue;
                        }
                        if (ConditionalsRegistry.isDoor(id)) {
                            RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2323(prop, blockSetType));
                            continue;
                        }
                        RegistryEntryReferences.registryEntry(MODID, id, Registration.getBlocksField(blockId.reflectedLocation().getFabric(), prop));
                        continue;
                    }
                    RegistryEntryReferences.registryEntry(MODID, id, new class_2248(prop));
                }
            }
        }
    }

    public static void setRegistriesLeave(String MODID, List<String> list) {
        McwRegistry.setRegistriesLeave(MODID, McwRegistry.makeDefaultFromList(list, class_2498.field_11535));
    }

    public static void setRegistriesLeave(String MODID, Map<String, class_2498> stringSoundTypeMap) {
        FabricLoader modList = FabricLoader.getInstance();
        LinkedHashMap<String, class_2498> orderedMap = new LinkedHashMap<String, class_2498>(stringSoundTypeMap);
        McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidLeave(ModType.FENCES);
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (Map.Entry map : orderedMap.entrySet()) {
                String mat = (String)map.getKey();
                class_2498 soundType = (class_2498)map.getValue();
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                boolean isModLoaded = modList.isModLoaded(mcwBlockIdBase.modid());
                class_4970.class_2251 prop = McwProperties.getLeaveProperties().method_9626(soundType);
                if (isModLoaded) {
                    RegistryEntryReferences.registryEntry(MODID, id, Registration.getBlocksField(blockId.reflectedLocation().getFabric(), prop));
                    continue;
                }
                RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2354(prop));
            }
        }
    }

    public static void setRegistriesStone(String MODID, List<String> list, ModType ... type) {
        McwRegistry.setRegistriesStone(MODID, McwRegistry.makeDefaultFromList(list, class_2498.field_11544), type);
    }

    public static void setRegistriesStone(String MODID, Map<String, class_2498> stringSoundTypeMap, ModType ... type) {
        FabricLoader modList = FabricLoader.getInstance();
        LinkedHashMap<String, class_2498> orderedMap = new LinkedHashMap<String, class_2498>(stringSoundTypeMap);
        for (ModType mod : type) {
            for (Map.Entry map : orderedMap.entrySet()) {
                String mat = (String)map.getKey();
                class_2498 soundType = (class_2498)map.getValue();
                class_4719 woodType = McwRegistry.getWoodType(soundType);
                McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidStone(mod);
                for (BlockId blockId : mcwBlockIdBase.blocks()) {
                    String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                    String reflectedLocation = blockId.reflectedLocation().getFabric();
                    boolean isModLoaded = modList.isModLoaded(mcwBlockIdBase.modid());
                    class_4970.class_2251 prop = McwProperties.getStoneProperties(mod).method_9626(soundType);
                    if (isModLoaded) {
                        if (ConditionalsRegistry.isBlockDefaultState("1.18.2Fabric", reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, Registration.getBlocksField(blockId.reflectedLocation().getFabric(), prop, class_2246.field_10340.method_9564()));
                            continue;
                        }
                        if (ConditionalsRegistry.isFence(reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2354(prop));
                            continue;
                        }
                        if (ConditionalsRegistry.isFenceGate(reflectedLocation)) {
                            RegistryEntryReferences.registryEntry(MODID, id, (class_2248)new class_2349(prop, woodType));
                            continue;
                        }
                        RegistryEntryReferences.registryEntry(MODID, id, Registration.getBlocksField(blockId.reflectedLocation().getFabric(), prop));
                        continue;
                    }
                    RegistryEntryReferences.registryEntry(MODID, id, new class_2248(prop));
                }
            }
        }
    }

    private static class_8177 getBlockSetType(class_2498 soundType) {
        if (soundType == class_2498.field_42766) {
            return class_8177.field_42827;
        }
        if (soundType == class_2498.field_40315) {
            return class_8177.field_42830;
        }
        if (soundType == class_2498.field_40314) {
            return class_8177.field_42833;
        }
        return class_8177.field_42823;
    }

    private static class_4719 getWoodType(class_2498 soundType) {
        if (soundType == class_2498.field_42766) {
            return class_4719.field_42837;
        }
        if (soundType == class_2498.field_40315) {
            return class_4719.field_22183;
        }
        if (soundType == class_2498.field_40314) {
            return class_4719.field_40350;
        }
        return class_4719.field_21676;
    }
}

