/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.datafixers.DSL;
import io.netty.buffer.Unpooled;
import java.util.Set;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;

public final class ProjectorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory {
    private ProjectorBlockEntityData projectorBlockEntityData = new ProjectorBlockEntityData();

    public static class_2591<ProjectorBlockEntity> create() {
        return new class_2591(ProjectorBlockEntity::new, Set.of(Slideshow.PROJECTOR), DSL.remainderType());
    }

    private ProjectorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(Slideshow.PROJECTOR_BLOCK_ENTITY, blockPos, blockState);
    }

    public void setProjectorBlockEntityData(ProjectorBlockEntityData projectorBlockEntityData) {
        this.projectorBlockEntityData = projectorBlockEntityData;
    }

    public void setProjectorBlockEntityData(ProjectorBlockEntityData projectorBlockEntityData, ProjectorBlock.InternalRotation rotation) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.projectorBlockEntityData = projectorBlockEntityData;
            this.method_5431();
            class_2680 blockState = (class_2680)this.method_11010().method_11657(ProjectorBlock.ROTATION, (Comparable)((Object)rotation));
            this.field_11863.method_8501(this.method_11016(), blockState);
            this.field_11863.method_8413(this.method_11016(), blockState, blockState, 2);
        }
    }

    public ProjectorBlockEntityData getProjectorBlockEntityData() {
        return this.projectorBlockEntityData;
    }

    public void method_11007(@Nonnull class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10582("ImageLocation", this.projectorBlockEntityData.getLocation());
        compoundTag.method_10569("Color", this.projectorBlockEntityData.getColor());
        compoundTag.method_10548("Width", this.projectorBlockEntityData.getWidth());
        compoundTag.method_10548("Height", this.projectorBlockEntityData.getHeight());
        compoundTag.method_10548("OffsetX", this.projectorBlockEntityData.getOffsetX());
        compoundTag.method_10548("OffsetY", this.projectorBlockEntityData.getOffsetY());
        compoundTag.method_10548("OffsetZ", this.projectorBlockEntityData.getOffsetZ());
        compoundTag.method_10556("DoubleSided", this.projectorBlockEntityData.isDoubleSided());
        compoundTag.method_10556("KeepAspectRatio", this.projectorBlockEntityData.isKeepAspectRatio());
    }

    public void method_11014(@Nonnull class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.projectorBlockEntityData.setLocation(compoundTag.method_10558("ImageLocation"));
        this.projectorBlockEntityData.setColor(compoundTag.method_10550("Color"));
        this.projectorBlockEntityData.setWidth(compoundTag.method_10583("Width"));
        this.projectorBlockEntityData.setHeight(compoundTag.method_10583("Height"));
        this.projectorBlockEntityData.setOffsetX(compoundTag.method_10583("OffsetX"));
        this.projectorBlockEntityData.setOffsetY(compoundTag.method_10583("OffsetY"));
        this.projectorBlockEntityData.setOffsetZ(compoundTag.method_10583("OffsetZ"));
        this.projectorBlockEntityData.setDoubleSided(compoundTag.method_10577("DoubleSided"));
        this.projectorBlockEntityData.setKeepAspectRatio(compoundTag.method_10577("KeepAspectRatio"));
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    @Nonnull
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"gui.slide_show.title");
    }

    public class_1703 createMenu(int i, @Nonnull class_1661 inventory, @Nonnull class_1657 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(this.method_11016());
        return Slideshow.PROJECTOR_SCREEN_HANDLER.create(i, inventory, buf);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public void transformToSlideSpace(Matrix4f pose, Matrix3f normal) {
        class_2680 state = this.method_11010();
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)state.method_11654(ProjectorBlock.ROTATION));
        pose.translate(0.5f, 0.5f, 0.5f);
        pose.rotate((Quaternionfc)direction.method_23224());
        normal.rotate((Quaternionfc)direction.method_23224());
        pose.translate(0.0f, 0.5f, 0.0f);
        rotation.transform(pose);
        rotation.transform(normal);
        pose.translate(-0.5f, 0.0f, 0.5f - this.projectorBlockEntityData.getHeight());
        pose.translate(this.getProjectorBlockEntityData().getOffsetX(), -this.getProjectorBlockEntityData().getOffsetZ(), this.projectorBlockEntityData.getOffsetY());
        pose.scale(this.projectorBlockEntityData.getWidth(), 1.0f, this.projectorBlockEntityData.getHeight());
    }

    public static class ProjectorBlockEntityData {
        private String mLocation = "";
        private int mColor = -1;
        private float mWidth = 1.0f;
        private float mHeight = 1.0f;
        private float mOffsetX = 0.0f;
        private float mOffsetY = 0.0f;
        private float mOffsetZ = 0.0f;
        private boolean mKeepAspectRatio = true;
        private boolean mDoubleSided = true;

        public ProjectorBlockEntityData copy() {
            ProjectorBlockEntityData copy = new ProjectorBlockEntityData();
            copy.setLocation(this.mLocation);
            copy.setColor(this.mColor);
            copy.setWidth(this.mWidth);
            copy.setHeight(this.mHeight);
            copy.setOffsetX(this.mOffsetX);
            copy.setOffsetY(this.mOffsetY);
            copy.setOffsetZ(this.mOffsetZ);
            copy.setKeepAspectRatio(this.mKeepAspectRatio);
            copy.setDoubleSided(this.mDoubleSided);
            return copy;
        }

        public String getLocation() {
            return this.mLocation;
        }

        public int getColor() {
            return this.mColor;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getHeight() {
            return this.mHeight;
        }

        public float getOffsetX() {
            return this.mOffsetX;
        }

        public float getOffsetY() {
            return this.mOffsetY;
        }

        public float getOffsetZ() {
            return this.mOffsetZ;
        }

        public boolean isKeepAspectRatio() {
            return this.mKeepAspectRatio;
        }

        public boolean isDoubleSided() {
            return this.mDoubleSided;
        }

        public void setLocation(String mLocation) {
            this.mLocation = mLocation;
        }

        public void setColor(int mColor) {
            this.mColor = mColor;
        }

        public void setWidth(float mWidth) {
            this.mWidth = mWidth;
        }

        public void setHeight(float mHeight) {
            this.mHeight = mHeight;
        }

        public void setOffsetX(float mOffsetX) {
            this.mOffsetX = mOffsetX;
        }

        public void setOffsetY(float mOffsetY) {
            this.mOffsetY = mOffsetY;
        }

        public void setOffsetZ(float mOffsetZ) {
            this.mOffsetZ = mOffsetZ;
        }

        public void setKeepAspectRatio(boolean mKeepAspectRatio) {
            this.mKeepAspectRatio = mKeepAspectRatio;
        }

        public void setDoubleSided(boolean mDoubleSided) {
            this.mDoubleSided = mDoubleSided;
        }
    }
}

