/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.client.renderer.fancypainting;

import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import earth.terrarium.handcrafted.client.renderer.fancypainting.FancyPaintingModel;
import earth.terrarium.handcrafted.common.entities.FancyPainting;
import earth.terrarium.handcrafted.common.registry.ModPaintingVariants;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1535;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class FancyPaintingRenderer
extends class_897<FancyPainting> {
    private static final class_2960 FRAME_SMALL_TEXTURE = new class_2960("handcrafted", "textures/painting/small_painting_frame.png");
    private static final class_2960 FRAME_MEDIUM_TEXTURE = new class_2960("handcrafted", "textures/painting/medium_painting_frame.png");
    private static final class_2960 FRAME_LARGE_TEXTURE = new class_2960("handcrafted", "textures/painting/large_painting_frame.png");
    private static final class_2960 FRAME_TALL_TEXTURE = new class_2960("handcrafted", "textures/painting/tall_painting_frame.png");
    private static final class_2960 FRAME_WIDE_TEXTURE = new class_2960("handcrafted", "textures/painting/wide_painting_frame.png");
    private static final Map<class_1535, class_2960> PAINTING_TEXTURES_BY_VARIANT = ModPaintingVariants.PAINTING_VARIANTS.stream().collect(Collectors.toUnmodifiableMap(RegistryEntry::get, v -> new class_2960("handcrafted", "textures/painting/" + v.getId().method_12832() + ".png")));
    private static final Map<class_1535, class_2960> FRAME_TEXTURES_BY_VARIANT = ModPaintingVariants.PAINTING_VARIANTS.stream().map(RegistryEntry::get).collect(Collectors.toUnmodifiableMap(v -> v, v -> {
        int width = v.method_6945();
        int height = v.method_6943();
        if (width == 16 && height == 16) {
            return FRAME_SMALL_TEXTURE;
        }
        if (width == 32 && height == 32) {
            return FRAME_MEDIUM_TEXTURE;
        }
        if (width == 48 && height == 32) {
            return FRAME_LARGE_TEXTURE;
        }
        if (width == 16 && height == 32) {
            return FRAME_TALL_TEXTURE;
        }
        if (width == 32 && height == 16) {
            return FRAME_WIDE_TEXTURE;
        }
        throw new IllegalStateException("Unknown painting variant: " + v);
    }));
    private final Map<class_1535, class_630> modelByVariant;

    public FancyPaintingRenderer(class_5617.class_5618 context) {
        super(context);
        class_630 small = context.method_32167(FancyPaintingModel.LAYER_LOCATION_SMALL).method_32086("main");
        class_630 medium = context.method_32167(FancyPaintingModel.LAYER_LOCATION_MEDIUM).method_32086("main");
        class_630 large = context.method_32167(FancyPaintingModel.LAYER_LOCATION_LARGE).method_32086("main");
        class_630 tall = context.method_32167(FancyPaintingModel.LAYER_LOCATION_TALL).method_32086("main");
        class_630 wide = context.method_32167(FancyPaintingModel.LAYER_LOCATION_WIDE).method_32086("main");
        this.modelByVariant = ModPaintingVariants.PAINTING_VARIANTS.stream().map(RegistryEntry::get).collect(Collectors.toUnmodifiableMap(v -> v, v -> {
            int width = v.method_6945();
            int height = v.method_6943();
            if (width == 16 && height == 16) {
                return small;
            }
            if (width == 32 && height == 32) {
                return medium;
            }
            if (width == 48 && height == 32) {
                return large;
            }
            if (width == 16 && height == 32) {
                return tall;
            }
            if (width == 32 && height == 16) {
                return wide;
            }
            throw new IllegalStateException("Unknown painting variant: " + v);
        }));
    }

    public void render(FancyPainting entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight) {
        class_1535 variant = (class_1535)entity.method_43404().comp_349();
        class_2350 direction = entity.method_5735();
        class_4588 frameVertex = buffer.getBuffer(class_1921.method_23572((class_2960)FRAME_TEXTURES_BY_VARIANT.get(variant)));
        int width = variant.method_6945();
        int height = variant.method_6943();
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_22905(0.8f, 0.8f, 0.8f);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(direction.method_10144()));
            poseStack.method_46416(0.0f, 0.875f, 0.46125f);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            this.modelByVariant.get(variant).method_22698(poseStack, frameVertex, packedLight, class_4608.field_21444);
            class_4588 paintingVertex = buffer.getBuffer(class_1921.method_23572((class_2960)this.getTextureLocation(entity)));
            poseStack.method_22904((double)((float)width / 2.0f / -16.0f), -0.125 + 0.5 * (double)((float)(32 - height) / 16.0f), 0.46125);
            poseStack.method_22905((float)width / 16.0f, (float)height / 16.0f, 1.0f);
            FancyPaintingRenderer.renderPainting(poseStack, paintingVertex, direction, packedLight);
        }
    }

    private static void renderPainting(class_4587 poseStack, class_4588 consumer, class_2350 dir, int light) {
        class_2382 normal = dir.method_10163();
        consumer.method_22918(poseStack.method_23760().method_23761(), 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(poseStack.method_23760().method_23762(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).method_1344();
        consumer.method_22918(poseStack.method_23760().method_23761(), 0.0f, 1.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(poseStack.method_23760().method_23762(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).method_1344();
        consumer.method_22918(poseStack.method_23760().method_23761(), 1.0f, 1.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(poseStack.method_23760().method_23762(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).method_1344();
        consumer.method_22918(poseStack.method_23760().method_23761(), 1.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_23763(poseStack.method_23760().method_23762(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).method_1344();
    }

    @NotNull
    public class_2960 getTextureLocation(FancyPainting entity) {
        return PAINTING_TEXTURES_BY_VARIANT.get(entity.method_43404().comp_349());
    }
}

