/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.sign_text_buffering;

import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.lwjgl.opengl.GL11C;

public class SignAtlasFramebuffer
extends class_276
implements AutoCloseable {
    public static final int ATLAS_SIZE = 4096;
    private final class_2960 textureId;
    private final Slot rootSlot;

    public SignAtlasFramebuffer() {
        super(false);
        this.method_1234(4096, 4096, class_310.field_1703);
        class_310.method_1551().method_1522().method_1235(true);
        this.textureId = new class_2960("immediatelyfast", "sign_atlas/" + this.field_1475);
        class_310.method_1551().method_1531().method_4616(this.textureId, (class_1044)new FboTexture());
        this.rootSlot = new Slot(null, 0, 0, 4096, 4096);
    }

    @Override
    public void close() {
        this.method_1238();
        class_310.method_1551().method_1522().method_1235(true);
    }

    public Slot findSlot(int width, int height) {
        return this.rootSlot.findSlot(width, height);
    }

    public void clear() {
        this.method_1230(class_310.field_1703);
        class_310.method_1551().method_1522().method_1235(true);
        this.rootSlot.subSlot1 = null;
        this.rootSlot.subSlot2 = null;
    }

    public class_2960 getTextureId() {
        return this.textureId;
    }

    private class FboTexture
    extends class_1044 {
        private FboTexture() {
        }

        public void method_4625(class_3300 manager) {
        }

        public void method_4528() {
        }

        public int method_4624() {
            return SignAtlasFramebuffer.this.field_1475;
        }
    }

    public class Slot {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final Slot parentSlot;
        public Slot subSlot1;
        public Slot subSlot2;
        public boolean occupied;

        public Slot(Slot parentSlot, int x, int y, int width, int height) {
            this.parentSlot = parentSlot;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void markFree() {
            if (this.subSlot1 != null || this.subSlot2 != null) {
                throw new UnsupportedOperationException("Cannot mark slot as free if it has sub slots");
            }
            if (!this.occupied) {
                throw new UnsupportedOperationException("Cannot mark slot as free if it is not occupied");
            }
            this.occupied = false;
            Slot.removeUnoccupiedSubSlots(this);
            GL11C.glScissor((int)this.x, (int)(4096 - this.y - this.height), (int)this.width, (int)this.height);
            GL11C.glEnable((int)3089);
            SignAtlasFramebuffer.this.method_1230(class_310.field_1703);
            GL11C.glDisable((int)3089);
            class_310.method_1551().method_1522().method_1235(true);
        }

        public Slot findSlot(int width, int height) {
            if (this.subSlot1 != null && this.subSlot2 != null) {
                Slot slot = this.subSlot1.findSlot(width, height);
                if (slot == null) {
                    slot = this.subSlot2.findSlot(width, height);
                }
                return slot;
            }
            if (this.occupied) {
                return null;
            }
            if (width > this.width || height > this.height) {
                return null;
            }
            if (width == this.width && height == this.height) {
                this.occupied = true;
                return this;
            }
            int k = this.width - width;
            int l = this.height - height;
            if (k > l) {
                this.subSlot1 = new Slot(this, this.x, this.y, width, this.height);
                this.subSlot2 = new Slot(this, this.x + width, this.y, this.width - width, this.height);
            } else {
                this.subSlot1 = new Slot(this, this.x, this.y, this.width, height);
                this.subSlot2 = new Slot(this, this.x, this.y + height, this.width, this.height - height);
            }
            return this.subSlot1.findSlot(width, height);
        }

        private static void removeUnoccupiedSubSlots(Slot slot) {
            boolean subSlot2Unoccupied;
            if (slot == null) {
                return;
            }
            Slot.removeUnoccupiedSubSlots(slot.parentSlot);
            boolean subSlot1Unoccupied = slot.subSlot1 != null && !Slot.hasOccupiedSlot(slot.subSlot1);
            boolean bl = subSlot2Unoccupied = slot.subSlot2 != null && !Slot.hasOccupiedSlot(slot.subSlot2);
            if (subSlot1Unoccupied && subSlot2Unoccupied) {
                slot.subSlot1 = null;
                slot.subSlot2 = null;
            }
        }

        private static boolean hasOccupiedSlot(Slot slot) {
            if (slot == null) {
                return false;
            }
            if (slot.occupied) {
                return true;
            }
            return Slot.hasOccupiedSlot(slot.subSlot1) || Slot.hasOccupiedSlot(slot.subSlot2);
        }
    }
}

