/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionBlockChangedPacket;
import com.simibubi.create.content.contraptions.ContraptionData;
import com.simibubi.create.content.contraptions.ContraptionDisassemblyPacket;
import com.simibubi.create.content.contraptions.ContraptionStallPacket;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsStopControllingPacket;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.sync.ContraptionSeatMappingPacket;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.mixin.accessor.ServerLevelAccessor;
import com.simibubi.create.foundation.utility.AdventureUtil;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.PortingLibEntity;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.EntityAccessor;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContraptionEntity
extends class_1297
implements IEntityAdditionalSpawnData {
    private static final class_2940<Boolean> STALLED = class_2945.method_12791(AbstractContraptionEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> CONTROLLED_BY = class_2945.method_12791(AbstractContraptionEntity.class, (class_2941)class_2943.field_13313);
    public final Map<class_1297, MutableInt> collidingEntities = new IdentityHashMap<class_1297, MutableInt>();
    protected Contraption contraption;
    protected boolean initialized;
    protected boolean prevPosInvalid = true;
    private boolean skipActorStop;
    public int staleTicks = 3;

    public AbstractContraptionEntity(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void setContraption(Contraption contraption) {
        this.contraption = contraption;
        if (contraption == null) {
            return;
        }
        if (this.method_37908().field_9236) {
            return;
        }
        contraption.onEntityCreated(this);
    }

    public void method_5784(class_1313 pType, class_243 pPos) {
        if (pType == class_1313.field_6309) {
            return;
        }
        if (pType == class_1313.field_6306) {
            return;
        }
        if (pType == class_1313.field_6310) {
            return;
        }
        super.method_5784(pType, pPos);
    }

    public boolean supportsTerrainCollision() {
        return this.contraption instanceof TranslatingContraption && !(this.contraption instanceof ElevatorContraption);
    }

    protected void contraptionInitialize() {
        this.contraption.onEntityInitialize(this.method_37908(), this);
        this.initialized = true;
    }

    public boolean collisionEnabled() {
        return true;
    }

    public void registerColliding(class_1297 collidingEntity) {
        this.collidingEntities.put(collidingEntity, new MutableInt());
    }

    public void addSittingPassenger(class_1297 passenger, int seatIndex) {
        for (class_1297 entity : this.method_5685()) {
            class_2338 seatOf = this.contraption.getSeatOf(entity.method_5667());
            if (seatOf == null || !seatOf.equals((Object)this.contraption.getSeats().get(seatIndex))) continue;
            if (entity instanceof class_1657) {
                return;
            }
            if (!(passenger instanceof class_1657)) {
                return;
            }
            entity.method_5848();
        }
        passenger.method_5873((class_1297)this, true);
        if (passenger instanceof class_1321) {
            class_1321 ta = (class_1321)passenger;
            ta.method_6179(true);
        }
        if (this.method_37908().field_9236) {
            return;
        }
        this.contraption.getSeatMapping().put(passenger.method_5667(), seatIndex);
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionSeatMappingPacket(this.method_5628(), this.contraption.getSeatMapping()), (class_1297)this);
    }

    protected void method_5793(class_1297 passenger) {
        if (this.contraption == null) {
            return;
        }
        class_243 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        super.method_5793(passenger);
        if (passenger instanceof class_1321) {
            class_1321 ta = (class_1321)passenger;
            ta.method_6179(false);
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (transformedVector != null) {
            passenger.getCustomData().method_10566("ContraptionDismountLocation", (class_2520)VecHelper.writeNBT(transformedVector));
        }
        this.contraption.getSeatMapping().remove(passenger.method_5667());
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionSeatMappingPacket(this.method_5628(), this.contraption.getSeatMapping(), passenger.method_5628()), (class_1297)this);
    }

    public class_243 method_24829(class_1309 entityLiving) {
        class_243 position = super.method_24829(entityLiving);
        class_2487 data = entityLiving.getCustomData();
        if (!data.method_10545("ContraptionDismountLocation")) {
            return position;
        }
        position = VecHelper.readNBT(data.method_10554("ContraptionDismountLocation", 6));
        data.method_10551("ContraptionDismountLocation");
        entityLiving.method_24830(false);
        if (!data.method_10545("ContraptionMountLocation")) {
            return position;
        }
        class_243 prevPosition = VecHelper.readNBT(data.method_10554("ContraptionMountLocation", 6));
        data.method_10551("ContraptionMountLocation");
        if (entityLiving instanceof class_1657) {
            class_1657 player = (class_1657)entityLiving;
            if (!prevPosition.method_24802((class_2374)position, 5000.0)) {
                AllAdvancements.LONG_TRAVEL.awardTo(player);
            }
        }
        return position;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        if (!this.method_5626(passenger)) {
            return;
        }
        class_243 transformedVector = this.getPassengerPosition(passenger, 1.0f);
        if (transformedVector == null) {
            return;
        }
        float offset = -0.125f;
        if (passenger instanceof AbstractContraptionEntity) {
            offset = 0.0f;
        }
        callback.accept(passenger, transformedVector.field_1352, transformedVector.field_1351 + SeatEntity.getCustomEntitySeatOffset(passenger) + (double)offset, transformedVector.field_1350);
    }

    public class_243 getPassengerPosition(class_1297 passenger, float partialTicks) {
        class_2338 localPos;
        if (this.contraption == null) {
            return null;
        }
        UUID id = passenger.method_5667();
        if (passenger instanceof OrientedContraptionEntity && (localPos = this.contraption.getBearingPosOf(id)) != null) {
            return this.toGlobalVector(VecHelper.getCenterOf((class_2382)localPos), partialTicks).method_1019(VecHelper.getCenterOf((class_2382)class_2338.field_10980)).method_1023(0.5, 1.0, 0.5);
        }
        class_238 bb = passenger.method_5829();
        double ySize = bb.method_17940();
        class_2338 seat = this.contraption.getSeatOf(id);
        if (seat == null) {
            return null;
        }
        class_243 transformedVector = this.toGlobalVector(class_243.method_24954((class_2382)seat).method_1031(0.5, passenger.method_5678() + ySize - (double)0.15f, 0.5), partialTicks).method_1019(VecHelper.getCenterOf((class_2382)class_2338.field_10980)).method_1023(0.5, ySize, 0.5);
        return transformedVector;
    }

    protected boolean method_5818(class_1297 p_184219_1_) {
        if (p_184219_1_ instanceof OrientedContraptionEntity) {
            return true;
        }
        return this.contraption.getSeatMapping().size() < this.contraption.getSeats().size();
    }

    public class_2561 getContraptionName() {
        return this.method_5477();
    }

    public Optional<UUID> getControllingPlayer() {
        return (Optional)this.field_6011.method_12789(CONTROLLED_BY);
    }

    public void setControllingPlayer(@Nullable UUID playerId) {
        this.field_6011.method_12778(CONTROLLED_BY, Optional.ofNullable(playerId));
    }

    public boolean startControlling(class_2338 controlsLocalPos, class_1657 player) {
        return false;
    }

    public boolean control(class_2338 controlsLocalPos, Collection<Integer> heldControls, class_1657 player) {
        return true;
    }

    public void stopControlling(class_2338 controlsLocalPos) {
        this.getControllingPlayer().map(arg_0 -> ((class_1937)this.method_37908()).method_18470(arg_0)).map(p -> p instanceof class_3222 ? (class_3222)p : null).ifPresent(p -> AllPackets.getChannel().sendToClient((S2CPacket)new ControlsStopControllingPacket(), p));
        this.setControllingPlayer(null);
    }

    public boolean handlePlayerInteraction(class_1657 player, class_2338 localPos, class_2350 side, class_1268 interactionHand) {
        int indexOfSeat = this.contraption.getSeats().indexOf(localPos);
        if (indexOfSeat == -1 || AllItems.WRENCH.isIn(player.method_5998(interactionHand))) {
            if (this.contraption.interactors.containsKey(localPos)) {
                return this.contraption.interactors.get(localPos).handlePlayerInteraction(player, interactionHand, localPos, this);
            }
            return this.contraption.storage.handlePlayerStorageInteraction(this.contraption, player, localPos);
        }
        if (player.method_5765()) {
            return false;
        }
        class_1297 toDismount = null;
        for (Map.Entry<UUID, Integer> entry : this.contraption.getSeatMapping().entrySet()) {
            if (entry.getValue() != indexOfSeat) continue;
            for (class_1297 entity : this.method_5685()) {
                if (!entry.getKey().equals(entity.method_5667())) continue;
                if (entity instanceof class_1657) {
                    return false;
                }
                toDismount = entity;
            }
        }
        if (toDismount != null && AdventureUtil.isAdventure(player)) {
            return false;
        }
        if (toDismount != null && !this.method_37908().field_9236) {
            class_243 transformedVector = this.getPassengerPosition(toDismount, 1.0f);
            toDismount.method_5848();
            if (transformedVector != null) {
                toDismount.method_5859(transformedVector.field_1352, transformedVector.field_1351, transformedVector.field_1350);
            }
        }
        if (this.method_37908().field_9236) {
            return true;
        }
        this.addSittingPassenger((class_1297)SeatBlock.getLeashed(this.method_37908(), player).or((Object)player), indexOfSeat);
        return true;
    }

    public class_243 toGlobalVector(class_243 localVec, float partialTicks) {
        return this.toGlobalVector(localVec, partialTicks, false);
    }

    public class_243 toGlobalVector(class_243 localVec, float partialTicks, boolean prevAnchor) {
        class_243 anchor = prevAnchor ? this.getPrevAnchorVec() : this.getAnchorVec();
        class_243 rotationOffset = VecHelper.getCenterOf((class_2382)class_2338.field_10980);
        localVec = localVec.method_1020(rotationOffset);
        localVec = this.applyRotation(localVec, partialTicks);
        localVec = localVec.method_1019(rotationOffset).method_1019(anchor);
        return localVec;
    }

    public class_243 toLocalVector(class_243 localVec, float partialTicks) {
        return this.toLocalVector(localVec, partialTicks, false);
    }

    public class_243 toLocalVector(class_243 globalVec, float partialTicks, boolean prevAnchor) {
        class_243 anchor = prevAnchor ? this.getPrevAnchorVec() : this.getAnchorVec();
        class_243 rotationOffset = VecHelper.getCenterOf((class_2382)class_2338.field_10980);
        globalVec = globalVec.method_1020(anchor).method_1020(rotationOffset);
        globalVec = this.reverseRotation(globalVec, partialTicks);
        globalVec = globalVec.method_1019(rotationOffset);
        return globalVec;
    }

    public void method_5773() {
        Object object;
        if (this.contraption == null) {
            this.method_31472();
            return;
        }
        this.collidingEntities.entrySet().removeIf(e -> ((MutableInt)e.getValue()).incrementAndGet() > 3);
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.prevPosInvalid = false;
        if (!this.initialized) {
            this.contraptionInitialize();
        }
        this.contraption.tickStorage(this);
        this.tickContraption();
        super.method_5773();
        if (this.method_37908().method_8608()) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
                if (!this.contraption.deferInvalidate) {
                    return;
                }
                this.contraption.deferInvalidate = false;
                ContraptionRenderDispatcher.invalidate(this.contraption);
            });
        }
        if (!((object = this.method_37908()) instanceof ServerLevelAccessor)) {
            return;
        }
        ServerLevelAccessor sl = (ServerLevelAccessor)object;
        for (class_1297 entity : this.method_5685()) {
            if (entity instanceof class_1657 || entity.method_31747() || sl.create$getEntityTickList().method_31793(entity)) continue;
            this.method_24201(entity);
        }
    }

    public void alignPassenger(class_1297 passenger) {
        class_243 motion = this.getContactPointMotion(passenger.method_33571());
        if (class_3532.method_20390((double)motion.method_1033(), (double)0.0)) {
            return;
        }
        if (passenger instanceof class_1531) {
            return;
        }
        if (!(passenger instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)passenger;
        float prevAngle = living.method_36454();
        float angle = AngleHelper.deg(-class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350));
        angle = AngleHelper.angleLerp(0.4f, prevAngle, angle);
        if (this.method_37908().field_9236) {
            living.method_5759(0.0, 0.0, 0.0, 0.0f, 0.0f, 0, false);
            living.method_5683(0.0f, 0);
            living.method_36456(angle);
            living.method_36457(0.0f);
            living.field_6283 = angle;
            living.field_6241 = angle;
        } else {
            living.method_36456(angle);
        }
    }

    public void setBlock(class_2338 localPos, class_3499.class_3501 newInfo) {
        this.contraption.blocks.put(localPos, newInfo);
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionBlockChangedPacket(this.method_5628(), localPos, newInfo.comp_1342()), (class_1297)this);
    }

    protected abstract void tickContraption();

    public abstract class_243 applyRotation(class_243 var1, float var2);

    public abstract class_243 reverseRotation(class_243 var1, float var2);

    public void tickActors() {
        boolean stalledPreviously = this.contraption.stalled;
        if (!this.method_37908().field_9236) {
            this.contraption.stalled = false;
        }
        this.skipActorStop = true;
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            class_3499.class_3501 blockInfo = (class_3499.class_3501)pair.left;
            MovementBehaviour actor = AllMovementBehaviours.getBehaviour(blockInfo.comp_1342());
            if (actor == null) continue;
            class_243 oldMotion = context.motion;
            class_243 actorPosition = this.toGlobalVector(VecHelper.getCenterOf((class_2382)blockInfo.comp_1341()).method_1019(actor.getActiveAreaOffset(context)), 1.0f);
            class_2338 gridPosition = class_2338.method_49638((class_2374)actorPosition);
            boolean newPosVisited = !context.stall && this.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition);
            context.rotation = v -> this.applyRotation((class_243)v, 1.0f);
            context.position = actorPosition;
            if (!this.isActorActive(context, actor) && !actor.mustTickWhileDisabled()) continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                if (!this.method_5805()) break;
                context.firstMovement = false;
            }
            if (!oldMotion.equals((Object)context.motion)) {
                actor.onSpeedChanged(context, oldMotion, context.motion);
                if (!this.method_5805()) break;
            }
            actor.tick(context);
            if (!this.method_5805()) break;
            this.contraption.stalled |= context.stall;
        }
        if (!this.method_5805()) {
            this.contraption.stop(this.method_37908());
            return;
        }
        this.skipActorStop = false;
        for (class_1297 entity : this.method_5685()) {
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(entity.method_5667())) continue;
            OrientedContraptionEntity orientedCE = (OrientedContraptionEntity)entity;
            if (orientedCE.contraption == null || !orientedCE.contraption.stalled) continue;
            this.contraption.stalled = true;
            break;
        }
        if (!this.method_37908().field_9236) {
            if (!stalledPreviously && this.contraption.stalled) {
                this.onContraptionStalled();
            }
            this.field_6011.method_12778(STALLED, (Object)this.contraption.stalled);
            return;
        }
        this.contraption.stalled = this.isStalled();
    }

    public void refreshPSIs() {
        for (MutablePair<class_3499.class_3501, MovementContext> pair : this.contraption.getActors()) {
            MovementContext context = (MovementContext)pair.right;
            class_3499.class_3501 blockInfo = (class_3499.class_3501)pair.left;
            MovementBehaviour actor = AllMovementBehaviours.getBehaviour(blockInfo.comp_1342());
            if (!(actor instanceof PortableStorageInterfaceMovement) || !this.isActorActive(context, actor) || context.position == null) continue;
            actor.visitNewPosition(context, class_2338.method_49638((class_2374)context.position));
        }
    }

    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        return actor.isActive(context);
    }

    protected void onContraptionStalled() {
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionStallPacket(this.method_5628(), this.method_23317(), this.method_23318(), this.method_23321(), this.getStalledAngle()), (class_1297)this);
    }

    protected boolean shouldActorTrigger(MovementContext context, class_3499.class_3501 blockInfo, MovementBehaviour actor, class_243 actorPosition, class_2338 gridPosition) {
        CarriageContraptionEntity cce;
        AbstractContraptionEntity abstractContraptionEntity;
        class_243 previousPosition = context.position;
        if (previousPosition == null) {
            return false;
        }
        context.motion = actorPosition.method_1020(previousPosition);
        if (!this.method_37908().method_8608() && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)abstractContraptionEntity).getCarriage() != null) {
            Train train = cce.getCarriage().train;
            double actualSpeed = train.speedBeforeStall != null ? train.speedBeforeStall : train.speed;
            context.motion = context.motion.method_1029().method_1021(Math.abs(actualSpeed));
        }
        class_243 relativeMotion = context.motion;
        context.relativeMotion = relativeMotion = this.reverseRotation(relativeMotion, 1.0f);
        boolean ignoreMotionForFirstMovement = context.contraption instanceof CarriageContraption || actor instanceof PortableStorageInterfaceMovement;
        return !class_2338.method_49638((class_2374)previousPosition).equals((Object)gridPosition) || (context.relativeMotion.method_1033() > 0.0 || ignoreMotionForFirstMovement) && context.firstMovement;
    }

    public void move(double x, double y, double z) {
        this.method_5814(this.method_23317() + x, this.method_23318() + y, this.method_23321() + z);
    }

    public class_243 getAnchorVec() {
        return this.method_19538();
    }

    public class_243 getPrevAnchorVec() {
        return this.getPrevPositionVec();
    }

    public float getYawOffset() {
        return 0.0f;
    }

    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
        if (this.contraption == null) {
            return;
        }
        class_238 cbox = this.contraption.bounds;
        if (cbox == null) {
            return;
        }
        class_243 actualVec = this.getAnchorVec();
        this.method_5857(cbox.method_997(actualVec));
    }

    public static float yawFromVector(class_243 vec) {
        return (float)((4.71238898038469 + Math.atan2(vec.field_1350, vec.field_1352)) / Math.PI * 180.0);
    }

    public static float pitchFromVector(class_243 vec) {
        return (float)(Math.acos(vec.field_1351) / Math.PI * 180.0);
    }

    public static FabricEntityTypeBuilder<?> build(FabricEntityTypeBuilder<?> builder) {
        return builder.dimensions(class_4048.method_18385((float)1.0f, (float)1.0f));
    }

    protected void method_5693() {
        this.field_6011.method_12784(STALLED, (Object)false);
        this.field_6011.method_12784(CONTROLLED_BY, Optional.empty());
    }

    public class_2596<class_2602> method_18002() {
        return PortingLibEntity.getEntitySpawningPacket((class_1297)this);
    }

    public void writeSpawnData(class_2540 buffer) {
        class_2487 compound = new class_2487();
        this.writeAdditional(compound, true);
        if (ContraptionData.isTooLargeForSync(compound)) {
            String info = this.getContraption().getType().id + " @" + this.method_19538() + " (" + this.method_5845() + ")";
            Create.LOGGER.warn("Could not send Contraption Spawn Data (Packet too big): " + info);
            compound = null;
        }
        buffer.method_10794(compound);
    }

    protected final void method_5652(class_2487 compound) {
        this.writeAdditional(compound, false);
    }

    protected void writeAdditional(class_2487 compound, boolean spawnPacket) {
        if (this.contraption != null) {
            compound.method_10566("Contraption", (class_2520)this.contraption.writeNBT(spawnPacket));
        }
        compound.method_10556("Stalled", this.isStalled());
        compound.method_10556("Initialized", this.initialized);
    }

    public void readSpawnData(class_2540 additionalData) {
        class_2487 nbt = additionalData.method_30617();
        if (nbt != null) {
            this.readAdditional(nbt, true);
        }
    }

    protected final void method_5749(class_2487 compound) {
        this.readAdditional(compound, false);
    }

    protected void readAdditional(class_2487 compound, boolean spawnData) {
        if (compound.method_33133()) {
            return;
        }
        this.initialized = compound.method_10577("Initialized");
        this.contraption = Contraption.fromNBT(this.method_37908(), compound.method_10562("Contraption"), spawnData);
        this.contraption.entity = this;
        this.field_6011.method_12778(STALLED, (Object)compound.method_10577("Stalled"));
    }

    public void disassemble() {
        if (!this.method_5805()) {
            return;
        }
        if (this.contraption == null) {
            return;
        }
        StructureTransform transform = this.makeStructureTransform();
        this.contraption.stop(this.method_37908());
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionDisassemblyPacket(this.method_5628(), transform), (class_1297)this);
        this.contraption.addBlocksToWorld(this.method_37908(), transform);
        this.contraption.addPassengersToWorld(this.method_37908(), transform, this.method_5685());
        for (class_1297 entity : this.method_5685()) {
            UUID id;
            if (!(entity instanceof OrientedContraptionEntity) || !this.contraption.stabilizedSubContraptions.containsKey(id = entity.method_5667())) continue;
            class_2338 transformed = transform.apply(this.contraption.stabilizedSubContraptions.get(id).getConnectedPos());
            entity.method_5814((double)transformed.method_10263(), (double)transformed.method_10264(), (double)transformed.method_10260());
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.skipActorStop = true;
        this.method_31472();
        this.method_5772();
        this.moveCollidedEntitiesOnDisassembly(transform);
        AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.method_37908(), (class_2382)this.method_24515());
    }

    private void moveCollidedEntitiesOnDisassembly(StructureTransform transform) {
        for (class_1297 entity : this.collidingEntities.keySet()) {
            class_243 localVec = this.toLocalVector(entity.method_19538(), 0.0f);
            class_243 transformed = transform.apply(localVec);
            if (this.method_37908().field_9236) {
                entity.method_5814(transformed.field_1352, transformed.field_1351 + 0.0625, transformed.field_1350);
                continue;
            }
            entity.method_5859(transformed.field_1352, transformed.field_1351 + 0.0625, transformed.field_1350);
        }
    }

    public void method_5650(class_1297.class_5529 p_146834_) {
        if (!(this.method_37908().field_9236 || this.method_31481() || this.contraption == null || this.skipActorStop)) {
            this.contraption.stop(this.method_37908());
        }
        if (this.contraption != null) {
            this.contraption.onEntityRemoved(this);
        }
        super.method_5650(p_146834_);
    }

    protected abstract StructureTransform makeStructureTransform();

    public void method_5768() {
        this.method_5772();
        super.method_5768();
    }

    protected void method_5825() {
        this.method_5772();
        super.method_5825();
    }

    protected void method_5746() {
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public boolean isStalled() {
        return (Boolean)this.field_6011.method_12789(STALLED);
    }

    @Environment(value=EnvType.CLIENT)
    static void handleStallPacket(ContraptionStallPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityID);
        if (class_12972 instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)class_12972;
            ce.handleStallInformation(packet.x, packet.y, packet.z, packet.angle);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static void handleBlockChangedPacket(ContraptionBlockChangedPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityID);
        if (class_12972 instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)class_12972;
            ce.handleBlockChange(packet.localPos, packet.newState);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static void handleDisassemblyPacket(ContraptionDisassemblyPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityID);
        if (class_12972 instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ce = (AbstractContraptionEntity)class_12972;
            ce.moveCollidedEntitiesOnDisassembly(packet.transform);
        }
    }

    protected abstract float getStalledAngle();

    protected abstract void handleStallInformation(double var1, double var3, double var5, float var7);

    @Environment(value=EnvType.CLIENT)
    protected void handleBlockChange(class_2338 localPos, class_2680 newState) {
        if (this.contraption == null || !this.contraption.blocks.containsKey(localPos)) {
            return;
        }
        class_3499.class_3501 info = this.contraption.blocks.get(localPos);
        this.contraption.blocks.put(localPos, new class_3499.class_3501(info.comp_1341(), newState, info.comp_1343()));
        if (info.comp_1342() != newState && !(newState.method_26204() instanceof SlidingDoorBlock)) {
            this.contraption.deferInvalidate = true;
        }
        this.contraption.invalidateColliders();
    }

    public class_2487 method_5647(class_2487 nbt) {
        class_243 vec = this.method_19538();
        List passengers = this.method_5685();
        for (class_1297 entity : passengers) {
            ((EntityAccessor)entity).port_lib$setRemovalReason(class_1297.class_5529.field_27000);
            class_243 prevVec = entity.method_19538();
            entity.method_23327(vec.field_1352, prevVec.field_1351, vec.field_1350);
            ((EntityAccessor)entity).port_lib$setRemovalReason(null);
        }
        class_2487 tag = super.method_5647(nbt);
        return tag;
    }

    public void method_18799(class_243 motionIn) {
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public void setContraptionMotion(class_243 vec) {
        super.method_18799(vec);
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    public class_243 getPrevPositionVec() {
        return this.prevPosInvalid ? this.method_19538() : new class_243(this.field_6014, this.field_6036, this.field_5969);
    }

    public abstract ContraptionRotationState getRotationState();

    public class_243 getContactPointMotion(class_243 globalContactPoint) {
        if (this.prevPosInvalid) {
            return class_243.field_1353;
        }
        class_243 contactPoint = this.toGlobalVector(this.toLocalVector(globalContactPoint, 0.0f, true), 1.0f, true);
        class_243 contraptionLocalMovement = contactPoint.method_1020(globalContactPoint);
        class_243 contraptionAnchorMovement = this.method_19538().method_1020(this.getPrevPositionVec());
        return contraptionLocalMovement.method_1019(contraptionAnchorMovement);
    }

    public boolean method_30949(class_1297 e) {
        if (e instanceof class_1657 && e.method_7325()) {
            return false;
        }
        if (e.field_5960) {
            return false;
        }
        if (e instanceof class_1530) {
            return false;
        }
        if (e instanceof class_1688) {
            return !(this.contraption instanceof MountedContraption);
        }
        if (e instanceof SuperGlueEntity) {
            return false;
        }
        if (e instanceof SeatEntity) {
            return false;
        }
        if (e instanceof class_1676) {
            return false;
        }
        if (e.method_5854() != null) {
            return false;
        }
        for (class_1297 riding = this.method_5854(); riding != null; riding = riding.method_5854()) {
            if (riding != e) continue;
            return false;
        }
        return e.method_5657() == class_3619.field_15974;
    }

    public boolean method_5817() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void applyLocalTransforms(class_4587 var1, float var2);

    protected boolean method_5876() {
        return false;
    }

    public void method_5639(int p_70015_1_) {
    }

    public boolean isReadyForRender() {
        return this.initialized;
    }

    public boolean isAliveOrStale() {
        return this.method_5805() || this.method_37908().method_8608() ? this.staleTicks > 0 : false;
    }

    public static class ContraptionRotationState {
        public static final ContraptionRotationState NONE = new ContraptionRotationState();
        public float xRotation = 0.0f;
        public float yRotation = 0.0f;
        public float zRotation = 0.0f;
        public float secondYRotation = 0.0f;
        Matrix3d matrix;

        public Matrix3d asMatrix() {
            if (this.matrix != null) {
                return this.matrix;
            }
            this.matrix = new Matrix3d().asIdentity();
            if (this.xRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asXRotation(AngleHelper.rad(-this.xRotation)));
            }
            if (this.yRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asYRotation(AngleHelper.rad(-this.yRotation)));
            }
            if (this.zRotation != 0.0f) {
                this.matrix.multiply(new Matrix3d().asZRotation(AngleHelper.rad(-this.zRotation)));
            }
            return this.matrix;
        }

        public boolean hasVerticalRotation() {
            return this.xRotation != 0.0f || this.zRotation != 0.0f;
        }

        public float getYawOffset() {
            return this.secondYRotation;
        }
    }
}

